package org.seasar.framework.util;

import java.text.SimpleDateFormat;

public final class FloatConversionUtil {

	private FloatConversionUtil() {
	}

	public static Float toFloat(Object o) {
		return toFloat(o, null);
	}
	
	public static Float toFloat(Object o, String pattern) {
		if (o == null) {
			return null;
		} else if (o instanceof Float) {
			return (Float) o;
		} else if (o instanceof Number) {
			return new Float(((Number) o).floatValue());
		} else if (o instanceof String) {
			return Float.valueOf((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return new Float(new SimpleDateFormat(pattern).format(o));
			} else {
				return new Float(((java.util.Date) o).getTime());
			}
		} else {
			return new Float(o.toString());
		}
	}
	
	public static float toPrimitiveFloat(Object o) {
		return toPrimitiveFloat(o, null);
	}

	public static float toPrimitiveFloat(Object o, String pattern) {
		if (o == null) {
			return 0;
		} else if (o instanceof Number) {
			return ((Number) o).floatValue();
		} else if (o instanceof String) {
			return Float.parseFloat((String) o);
		} else if (o instanceof java.util.Date) {
			if (pattern != null) {
				return Float.parseFloat(new SimpleDateFormat(pattern).format(o));
			} else {
				return ((java.util.Date) o).getTime();
			}
		} else {
			return Float.parseFloat(o.toString());
		}
	}
}
