package test.org.seasar.extension.mock.servlet;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.seasar.extension.mock.servlet.MockHttpServletRequest;
import org.seasar.extension.mock.servlet.MockServletContext;

public class MockHttpServletRequestTest extends TestCase {

	private MockServletContext context_;
	private MockHttpServletRequest request_;

	public MockHttpServletRequestTest(String name) {
		super(name);
	}

	public void testAddParameter() throws Exception {
		request_.addParameter("aaa", "111");
		String[] values = request_.getParameterValues("aaa");
		assertEquals("1", 1, values.length);
		assertEquals("2", "111", values[0]);
		request_.addParameter("aaa", "222");
		values = request_.getParameterValues("aaa");
		assertEquals("3", 2, values.length);
		assertEquals("4", "111", values[0]);
		assertEquals("5", "222", values[1]);
	}

	protected void setUp() throws Exception {
		context_ = new MockServletContext("/s2jsf-example");
		request_ = context_.createRequest("/hello.html");
	}

	protected void tearDown() throws Exception {
	}

	public static Test suite() {
		return new TestSuite(MockHttpServletRequestTest.class);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner
				.main(new String[] { MockHttpServletRequestTest.class.getName() });
	}
}