/*
 * Decompiled with CFR 0.152.
 */
package groovy.ui;

import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import groovy.ui.GroovySocketServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;

public class GroovyMain {
    private List args;
    private boolean isScriptFile;
    private String script;
    private boolean processFiles;
    private boolean editFiles;
    private boolean autoOutput;
    private boolean processSockets;
    private int port;
    private String backupExtension;
    private CompilerConfiguration conf = new CompilerConfiguration();

    public static void main(String[] args) {
        MetaClass.setUseReflection(true);
        Options options = GroovyMain.buildOptions();
        try {
            CommandLine cmd = GroovyMain.parseCommandLine(options, args);
            if (cmd.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("groovy", options);
            } else if (cmd.hasOption('v')) {
                String version = InvokerHelper.getVersion();
                System.out.println("Groovy Version: " + version + " JVM: " + System.getProperty("java.vm.version"));
            } else {
                GroovyMain.process(cmd);
            }
        }
        catch (ParseException pe) {
            System.out.println("error: " + pe.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("groovy", options);
        }
    }

    private static CommandLine parseCommandLine(Options options, String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args, true);
        return cmd;
    }

    private static Options buildOptions() {
        Options options = new Options();
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"usage information");
        OptionBuilder.withLongOpt((String)"help");
        options.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"display the Groovy and JVM versions");
        OptionBuilder.withLongOpt((String)"version");
        options.addOption(OptionBuilder.create((char)'v'));
        OptionBuilder.withArgName((String)"charset");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify the encoding of the files");
        OptionBuilder.withLongOpt((String)"encoding");
        options.addOption(OptionBuilder.create((char)'c'));
        OptionBuilder.withArgName((String)"script");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"specify a command line script");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withArgName((String)"extension");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"modify files in place");
        options.addOption(OptionBuilder.create((char)'i'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"process files line by line");
        options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"process files line by line and print result");
        options.addOption(OptionBuilder.create((char)'p'));
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription((String)"listen on a port and process inbound lines");
        options.addOption(OptionBuilder.create((char)'l'));
        return options;
    }

    private static void process(CommandLine line) throws ParseException {
        GroovyMain main = new GroovyMain();
        List args = line.getArgList();
        if (line.hasOption('c')) {
            main.conf.setSourceEncoding(line.getOptionValue("encoding"));
        }
        main.isScriptFile = !line.hasOption('e');
        main.processFiles = line.hasOption('p') || line.hasOption('n');
        main.autoOutput = line.hasOption('p');
        main.editFiles = line.hasOption('i');
        if (main.editFiles) {
            main.backupExtension = line.getOptionValue('i');
        }
        if (main.isScriptFile) {
            if (args.isEmpty()) {
                throw new ParseException("neither -e or filename provided");
            }
            main.script = (String)args.remove(0);
            if (main.script.endsWith(".java")) {
                throw new ParseException("error: cannot compile file with .java extension: " + main.script);
            }
        } else {
            main.script = line.getOptionValue('e');
        }
        main.processSockets = line.hasOption('l');
        if (main.processSockets) {
            String p = line.getOptionValue('l', "1960");
            main.port = new Integer(p);
        }
        main.args = args;
        main.run();
    }

    private void run() {
        try {
            if (this.processSockets) {
                this.processSockets();
            } else if (this.processFiles) {
                this.processFiles();
            } else {
                this.processOnce();
            }
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    private void processSockets() throws CompilationFailedException, IOException {
        GroovyShell groovy = new GroovyShell(this.conf);
        if (this.isScriptFile) {
            Script s = groovy.parse(new File(this.script));
        } else {
            Script s = groovy.parse(this.script, "main");
        }
        new GroovySocketServer(groovy, this.isScriptFile, this.script, this.autoOutput, this.port);
    }

    private void processFiles() throws CompilationFailedException, IOException {
        GroovyShell groovy = new GroovyShell(this.conf);
        Script s = null;
        s = this.isScriptFile ? groovy.parse(new File(this.script)) : groovy.parse(this.script, "main");
        if (this.args.isEmpty()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            PrintWriter writer = new PrintWriter(System.out);
            this.processReader(s, reader, writer);
        } else {
            Iterator i = this.args.iterator();
            while (i.hasNext()) {
                String filename = (String)i.next();
                File file = new File(filename);
                this.processFile(s, file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(Script s, File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        if (!this.editFiles) {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                PrintWriter writer = new PrintWriter(System.out);
                this.processReader(s, reader, writer);
                writer.flush();
            }
            finally {
                reader.close();
            }
        }
        File backup = null;
        if (this.backupExtension == null) {
            backup = File.createTempFile("groovy_", ".tmp");
            backup.deleteOnExit();
        } else {
            backup = new File(file.getPath() + this.backupExtension);
            backup.delete();
        }
        if (!file.renameTo(backup)) {
            throw new IOException("unable to rename " + file + " to " + backup);
        }
        BufferedReader reader = new BufferedReader(new FileReader(backup));
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            try {
                this.processReader(s, reader, writer);
            }
            finally {
                writer.close();
            }
        }
        finally {
            reader.close();
        }
    }

    private void processReader(Script s, BufferedReader reader, PrintWriter pw) throws IOException {
        String line = null;
        s.setProperty("out", pw);
        while ((line = reader.readLine()) != null) {
            s.setProperty("line", line);
            Object o = s.run();
            if (!this.autoOutput) continue;
            pw.println(o);
        }
    }

    private void processOnce() throws CompilationFailedException, IOException {
        GroovyShell groovy = new GroovyShell(this.conf);
        if (this.isScriptFile) {
            groovy.run(new File(this.script), this.args);
        } else {
            groovy.run(this.script, "main", this.args);
        }
    }
}

