/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.BuilderSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.DataType;
import org.codehaus.groovy.ant.FileScanner;
import org.codehaus.groovy.runtime.InvokerHelper;

public class AntBuilder
extends BuilderSupport {
    private static final Class[] addTaskParamTypes = new Class[]{String.class};
    private Logger log = Logger.getLogger(this.getClass().getName());
    private Project project;

    public AntBuilder() {
        this.project = this.createProject();
    }

    public AntBuilder(Project project) {
        this.project = project;
    }

    protected Project createProject() {
        Project project = new Project();
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.init();
        project.getBaseDir();
        return project;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected void nodeCompleted(Object parent, Object node) {
        if (node instanceof Task) {
            Task task = (Task)node;
            task.perform();
        }
    }

    protected Object createNode(Object tagName) {
        return this.createNode((Object)tagName.toString(), Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        Object task = this.createNode(name);
        this.setText(task, value.toString());
        return task;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object task = this.createNode(name, attributes);
        this.setText(task, value.toString());
        return task;
    }

    protected Object createNode(Object name, Map attributes) {
        Object id;
        if (name.equals("fileScanner")) {
            return new FileScanner(this.project);
        }
        String tagName = name.toString();
        Object answer = null;
        Object parentObject = this.getCurrent();
        Task parentTask = this.getParentTask();
        Object nested = null;
        if (parentObject != null && !(parentTask instanceof TaskContainer)) {
            nested = this.createNestedObject(parentObject, tagName);
        }
        Task task = null;
        if (nested == null && (task = this.createTask(tagName)) != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Creating an ant Task for name: " + tagName);
            }
            answer = task instanceof TaskAdapter ? ((TaskAdapter)task).getProxy() : task;
            id = attributes.remove("id");
            if (id != null) {
                this.project.addReference((String)id, (Object)task);
            }
            task.init();
            this.setBeanProperties(task, attributes);
        }
        if (task == null) {
            if (nested == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Trying to create a data type for tag: " + tagName);
                }
                nested = this.createDataType(tagName);
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Created nested property tag: " + tagName);
            }
            if (nested != null) {
                answer = nested;
                id = attributes.remove("id");
                if (id != null) {
                    this.project.addReference((String)id, nested);
                }
                try {
                    InvokerHelper.setProperty(nested, "name", tagName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.setBeanProperties(nested, attributes);
                if (parentObject != null) {
                    IntrospectionHelper ih = IntrospectionHelper.getHelper(parentObject.getClass());
                    try {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.fine("About to set the: " + tagName + " property on: " + parentObject + " to value: " + nested + " with type: " + nested.getClass());
                        }
                        ih.storeElement(this.project, parentObject, nested, tagName);
                    }
                    catch (Exception e) {
                        this.log.log(Level.WARNING, "Caught exception setting nested: " + tagName, e);
                    }
                    try {
                        InvokerHelper.setProperty(parentObject, tagName, nested);
                    }
                    catch (Exception e) {
                        this.log.fine("Caught exception trying to set property: " + tagName + " on: " + parentObject);
                    }
                }
            } else {
                this.log.log(Level.WARNING, "Could not convert tag: " + tagName + " into an Ant task, data type or property. Maybe the task is not on the classpath?");
            }
        }
        return answer;
    }

    protected void setText(Object task, String text) {
        Method method = this.getAccessibleMethod(task.getClass(), "addText", addTaskParamTypes);
        if (method != null) {
            Object[] args = new Object[]{text};
            try {
                method.invoke(task, args);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Cannot call addText on: " + task + ". Reason: " + e, e);
            }
        }
    }

    protected Method getAccessibleMethod(Class theClass, String name, Class[] paramTypes) {
        do {
            try {
                Method answer = theClass.getDeclaredMethod(name, paramTypes);
                if (answer != null) {
                    return answer;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        } while ((theClass = theClass.getSuperclass()) != null);
        return null;
    }

    public Project getAntProject() {
        return this.project;
    }

    protected void setBeanProperties(Object object, Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setBeanProperty(object, name, value == null ? null : value.toString());
        }
    }

    protected void setBeanProperty(Object object, String name, Object value) {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Setting bean property on: " + object + " name: " + name + " value: " + value);
        }
        IntrospectionHelper ih = IntrospectionHelper.getHelper(object.getClass());
        if (value instanceof String) {
            try {
                ih.setAttribute(this.getAntProject(), object, name.toLowerCase(), (String)value);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            ih.storeElement(this.getAntProject(), object, value, name);
        }
        catch (Exception e) {
            InvokerHelper.setProperty(object, name, value);
        }
    }

    protected Object createNestedObject(Object object, String name) {
        IntrospectionHelper ih;
        Object dataType = null;
        if (object != null && (ih = IntrospectionHelper.getHelper(object.getClass())) != null) {
            try {
                dataType = ih.createElement(this.getAntProject(), object, name.toLowerCase());
            }
            catch (BuildException be) {
                this.log.log(Level.SEVERE, "Caught: " + (Object)((Object)be), be);
            }
        }
        if (dataType == null) {
            dataType = this.createDataType(name);
        }
        return dataType;
    }

    protected Object createDataType(String name) {
        Object dataType = null;
        Class type = (Class)this.getAntProject().getDataTypeDefinitions().get(name);
        if (type != null) {
            Constructor ctor = null;
            boolean noArg = false;
            try {
                ctor = type.getConstructor(new Class[0]);
                noArg = true;
            }
            catch (NoSuchMethodException nse) {
                try {
                    ctor = type.getConstructor(Project.class);
                    noArg = false;
                }
                catch (NoSuchMethodException nsme) {
                    this.log.log(Level.INFO, "datatype '" + name + "' didn't have a constructor with an Ant Project", nsme);
                }
            }
            dataType = noArg ? this.createDataType(ctor, new Object[0], name, "no-arg constructor") : this.createDataType(ctor, new Object[]{this.getAntProject()}, name, "an Ant project");
            if (dataType != null) {
                ((DataType)dataType).setProject(this.getAntProject());
            }
        }
        return dataType;
    }

    protected Object createDataType(Constructor ctor, Object[] args, String name, String argDescription) {
        try {
            Object datatype = ctor.newInstance(args);
            return datatype;
        }
        catch (InstantiationException ie) {
            this.log.log(Level.SEVERE, "datatype '" + name + "' couldn't be created with " + argDescription, ie);
        }
        catch (IllegalAccessException iae) {
            this.log.log(Level.SEVERE, "datatype '" + name + "' couldn't be created with " + argDescription, iae);
        }
        catch (InvocationTargetException ite) {
            this.log.log(Level.SEVERE, "datatype '" + name + "' couldn't be created with " + argDescription, ite);
        }
        return null;
    }

    protected Task createTask(String taskName) {
        return this.createTask(taskName, (Class)this.getAntProject().getTaskDefinitions().get(taskName));
    }

    protected Task createTask(String taskName, Class taskType) {
        if (taskType == null) {
            return null;
        }
        try {
            Object o = taskType.newInstance();
            Task task = null;
            if (o instanceof Task) {
                task = (Task)o;
            } else {
                TaskAdapter taskA = new TaskAdapter();
                taskA.setProxy(o);
                task = taskA;
            }
            task.setProject(this.getAntProject());
            task.setTaskName(taskName);
            return task;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Could not create task: " + taskName + ". Reason: " + e, e);
            return null;
        }
    }

    protected Task getParentTask() {
        Object current = this.getCurrent();
        if (current instanceof Task) {
            return (Task)current;
        }
        return null;
    }
}

