/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control.messages;

import java.io.PrintWriter;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.syntax.SyntaxException;

public class SyntaxErrorMessage
extends Message {
    protected SyntaxException cause = null;

    public SyntaxErrorMessage(SyntaxException cause) {
        this.cause = cause;
    }

    public SyntaxException getCause() {
        return this.cause;
    }

    public void write(PrintWriter output, ProcessingUnit context, Janitor janitor) {
        SourceUnit source = (SourceUnit)context;
        String name = source.getName();
        int line = this.getCause().getStartLine();
        int column = this.getCause().getStartColumn();
        String sample = source.getSample(line, column, janitor);
        output.println(name + ": " + line + ": " + this.getCause().getMessage());
        if (sample != null) {
            output.println(source.getSample(line, column, janitor));
        }
        output.println("");
    }
}

