/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.MetaMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.runtime.NewInstanceMetaMethod;

public class GroovyCategorySupport {
    private static ThreadLocal local = new ThreadLocal(){

        protected Object initialValue() {
            ArrayList<Map> stack = new ArrayList<Map>();
            stack.add(Collections.EMPTY_MAP);
            return stack;
        }
    };

    public static List getCategoryMethods(Class categorizedClass, String name) {
        Map properties = GroovyCategorySupport.getProperties();
        ArrayList methodList = new ArrayList();
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            Map metaMethodsMap;
            List newMethodList;
            Class current = (Class)i.next();
            if (!current.isAssignableFrom(categorizedClass) || (newMethodList = (List)(metaMethodsMap = (Map)properties.get(current)).get(name)) == null) continue;
            methodList.addAll(newMethodList);
        }
        if (methodList.size() == 0) {
            return null;
        }
        return methodList;
    }

    private static void use(Class categoryClass) {
        Map properties = GroovyCategorySupport.getProperties();
        Method[] methods = categoryClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            Method method = methods[i];
            if (!Modifier.isStatic(method.getModifiers()) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
            Class<?> metaClass = paramTypes[0];
            Map metaMethodsMap = GroovyCategorySupport.getMetaMethods(properties, metaClass);
            List methodList = GroovyCategorySupport.getMethodList(metaMethodsMap, method.getName());
            NewInstanceMetaMethod mmethod = new NewInstanceMetaMethod(new MetaMethod(method)){

                public boolean isCacheable() {
                    return false;
                }
            };
            methodList.add(mmethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void use(Class clazz, Closure closure) {
        GroovyCategorySupport.newScope();
        try {
            GroovyCategorySupport.use(clazz);
            closure.call();
        }
        finally {
            GroovyCategorySupport.endScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void use(List classes, Closure closure) {
        GroovyCategorySupport.newScope();
        try {
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                Class clazz = (Class)i.next();
                GroovyCategorySupport.use(clazz);
            }
            closure.call();
        }
        finally {
            GroovyCategorySupport.endScope();
        }
    }

    private static void newScope() {
        List stack = (List)local.get();
        WeakHashMap properties = new WeakHashMap(GroovyCategorySupport.getProperties());
        stack.add(properties);
    }

    private static void endScope() {
        List stack = (List)local.get();
        stack.remove(stack.size() - 1);
    }

    private static Map getProperties() {
        List stack = (List)local.get();
        Map properties = (Map)stack.get(stack.size() - 1);
        return properties;
    }

    private static List getMethodList(Map metaMethodsMap, String name) {
        ArrayList methodList = (ArrayList)metaMethodsMap.get(name);
        if (methodList == null) {
            methodList = new ArrayList(1);
            metaMethodsMap.put(name, methodList);
        }
        return methodList;
    }

    private static Map getMetaMethods(Map properties, Class metaClass) {
        HashMap metaMethodsMap = (HashMap)properties.get(metaClass);
        if (metaMethodsMap == null) {
            metaMethodsMap = new HashMap();
            properties.put(metaClass, metaMethodsMap);
        }
        return metaMethodsMap;
    }
}

