/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.jsf.render.html.HtmlTagRenderer;

public class HtmlOutputLinkRenderer
extends HtmlTagRenderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String href = this.getValue(component, "value").toString();
        if (component.getChildCount() > 0) {
            StringBuffer hrefBuf = new StringBuffer(href);
            this.addChildParametersToHref(component, hrefBuf, href.indexOf(63) == -1, writer.getCharacterEncoding());
            href = hrefBuf.toString();
        }
        href = context.getExternalContext().encodeResourceURL(href);
        writer.startElement("a", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.writeURIAttribute("href", (Object)href, null);
        this.renderPathThroughAttributes(writer, component);
    }

    protected void addChildParametersToHref(UIComponent component, StringBuffer hrefBuf, boolean firstParameter, String encoding) throws UnsupportedEncodingException {
        Iterator it = component.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            if (!(child instanceof UIParameter)) continue;
            String name = ((UIParameter)child).getName();
            Object value = ((UIParameter)child).getValue();
            this.addChildParameterToHref(name, value, hrefBuf, firstParameter, encoding);
            firstParameter = false;
        }
    }

    protected void addChildParameterToHref(String name, Object value, StringBuffer hrefBuf, boolean firstParameter, String encoding) throws UnsupportedEncodingException {
        if (name == null) {
            throw new EmptyRuntimeException("name");
        }
        hrefBuf.append(firstParameter ? (char)'?' : '&');
        hrefBuf.append(URLEncoder.encode(name, encoding));
        hrefBuf.append('=');
        if (value != null) {
            hrefBuf.append(URLEncoder.encode(value.toString(), encoding));
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("a");
    }
}

