/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sourceforge.myfaces.config.MyfacesConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JavascriptUtils {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils == null ? (class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils = JavascriptUtils.class$("net.sourceforge.myfaces.renderkit.html.util.JavascriptUtils")) : class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils));
    public static final String JAVASCRIPT_DETECTED = (class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils == null ? (class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils = JavascriptUtils.class$("net.sourceforge.myfaces.renderkit.html.util.JavascriptUtils")) : class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils).getName() + ".JAVASCRIPT_DETECTED";
    private static final String AUTO_SCROLL_PARAM = "autoScroll";
    private static final String AUTO_SCROLL_FUNCTION = "getScrolling()";
    private static final String OLD_VIEW_ID = (class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils == null ? (class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils = JavascriptUtils.class$("net.sourceforge.myfaces.renderkit.html.util.JavascriptUtils")) : class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils) + ".OLD_VIEW_ID";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "delete", "do", "double", "else", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "in", "instanceof", "int", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "typeof", "var", "void", "while", "with"));
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$util$JavascriptUtils;

    private JavascriptUtils() {
    }

    public static String getValidJavascriptName(String s, boolean checkForReservedWord) {
        if (checkForReservedWord && RESERVED_WORDS.contains(s)) {
            return s + "_";
        }
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }

    public static String encodeString(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer sb = null;
        for (int i = 0; i < string.length(); ++i) {
            String app = null;
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    app = "\\";
                    break;
                }
                case '\"': {
                    app = "\\\"";
                    break;
                }
                case '\'': {
                    app = "\\'";
                    break;
                }
                case '\n': {
                    app = "\\n";
                }
            }
            if (app != null) {
                if (sb == null) {
                    sb = new StringBuffer(string.substring(0, i));
                }
                sb.append(app);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    public static boolean isJavascriptAllowed(ExternalContext externalContext) {
        MyfacesConfig myfacesConfig = MyfacesConfig.getCurrentInstance(externalContext);
        if (myfacesConfig.isAllowJavascript()) {
            if (myfacesConfig.isDetectJavascript()) {
                return JavascriptUtils.isJavascriptDetected(externalContext);
            }
            return true;
        }
        return false;
    }

    public static void setJavascriptDetected(ExternalContext externalContext, boolean value) {
        externalContext.getSessionMap().put(JAVASCRIPT_DETECTED, value);
    }

    public static boolean isJavascriptDetected(ExternalContext externalContext) {
        Boolean sessionValue = (Boolean)externalContext.getSessionMap().get(JAVASCRIPT_DETECTED);
        return sessionValue == null ? false : sessionValue;
    }

    public static void appendAutoScrollAssignment(StringBuffer onClickValue, String formName) {
        onClickValue.append("document.forms['").append(formName).append("']");
        onClickValue.append(".elements['").append(AUTO_SCROLL_PARAM).append("']");
        onClickValue.append(".value=").append(AUTO_SCROLL_FUNCTION).append(";");
    }

    public static void renderAutoScrollHiddenInput(ResponseWriter writer) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("name", (Object)AUTO_SCROLL_PARAM, null);
        writer.endElement("input");
    }

    public static void renderAutoScrollFunction(FacesContext facesContext, ResponseWriter writer) throws IOException {
        String scrolling;
        writer.write("\n<script language=\"JavaScript\">\n<!--\nfunction getScrolling() {\n    x = 0; y = 0;\n    if (document.body && document.body.scrollLeft && !isNaN(document.body.scrollLeft)) {\n        x = document.body.scrollLeft;\n    } else if (window.pageXOffset && !isNaN(window.pageXOffset)) {\n        x = window.pageXOffset;\n    }\n    if (document.body && document.body.scrollTop && !isNaN(document.body.scrollTop)) {\n        y = document.body.scrollTop;\n    } else if (window.pageYOffset && !isNaN(window.pageYOffset)) {\n        y = window.pageYOffset;\n    }\n    return x + \",\" + y;\n}\n");
        ExternalContext externalContext = facesContext.getExternalContext();
        String oldViewId = JavascriptUtils.getOldViewId(externalContext);
        if (oldViewId != null && oldViewId.equals(facesContext.getViewRoot().getViewId()) && (scrolling = (String)externalContext.getRequestParameterMap().get(AUTO_SCROLL_PARAM)) != null && scrolling.length() > 0) {
            String x = "0";
            String y = "0";
            int comma = scrolling.indexOf(44);
            if (comma == -1) {
                log.warn((Object)("Illegal autoscroll request parameter: " + scrolling));
            } else {
                x = scrolling.substring(0, comma);
                if (x.equals("undefined")) {
                    x = "0";
                }
                if ((y = scrolling.substring(comma + 1)).equals("undefined")) {
                    y = "0";
                }
            }
            writer.write("window.scrollTo(" + x + "," + y + ");\n");
        }
        writer.write("//-->\n</script>\n");
    }

    public static void setOldViewId(ExternalContext externalContext, String viewId) {
        externalContext.getRequestMap().put(OLD_VIEW_ID, viewId);
    }

    public static String getOldViewId(ExternalContext externalContext) {
        return (String)externalContext.getRequestMap().get(OLD_VIEW_ID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

