package org.seasar.jsf.template.impl.html;

import java.util.List;

import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.html.HtmlOption;
import org.seasar.jsf.template.impl.AbstractUIComponentBuilder;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlOptionBuilder extends AbstractUIComponentBuilder {

	public HtmlOptionBuilder(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		super(namespaceURI, localName, qName, attributes);
		addCustomPropertyName(JsfConstants.ACTION_ATTR);
	}

	public void buildTree(UIComponent parent) {
		if (!hasUISelectItems(parent)) {
			super.buildTree(parent);
		}
	}

	protected UIComponent createComponent() {
		return new HtmlOption();
	}

	protected void renameProperties() {
		super.renameProperties();
		renameProperty(JsfConstants.VALUE_ATTR, JsfConstants.ITEM_VALUE_ATTR);
	}
	
	protected boolean hasUISelectItems(UIComponent component) {
		List children = component.getChildren();
		for (int i = 0; i < children.size(); ++i) {
			if (children.get(i) instanceof UISelectItems) {
				return true;
			}
		}
		return false;
	}
}