/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.AbstractProcessTask;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public abstract class AbstractTransformTask
extends AbstractProcessTask {
    private boolean verbose;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract ClassTransformer getClassTransformer(String var1);

    protected void processFile(File file) throws Exception {
        DebuggingClassWriter w = new DebuggingClassWriter(true);
        String name = ClassNameReader.getClassName(AbstractTransformTask.getClassReader(file));
        ClassTransformer t = this.getClassTransformer(name);
        if (t != null) {
            new TransformingClassGenerator(new ClassReaderGenerator(AbstractTransformTask.getClassReader(file), true), t).generateClass((ClassVisitor)w);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(w.toByteArray());
            fos.close();
            if (this.verbose) {
                System.out.println("Enhancing class " + name);
            }
        }
    }

    private static ClassReader getClassReader(File file) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ClassReader r = new ClassReader((InputStream)in);
        ((InputStream)in).close();
        return r;
    }
}

