/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.node;

import java.lang.reflect.Array;
import java.util.List;
import org.seasar.dao.CommandContext;
import org.seasar.dao.node.AbstractNode;
import org.seasar.framework.util.OgnlUtil;

public class ParenBindVariableNode
extends AbstractNode {
    private String expression_;
    private Object parsedExpression_;

    public ParenBindVariableNode(String expression) {
        this.expression_ = expression;
        this.parsedExpression_ = OgnlUtil.parseExpression((String)expression);
    }

    public String getExpression() {
        return this.expression_;
    }

    public void accept(CommandContext ctx) {
        Object var = OgnlUtil.getValue((Object)this.parsedExpression_, (Object)ctx);
        if (var instanceof List) {
            this.bindArray(ctx, ((List)var).toArray());
        } else {
            if (var == null) {
                return;
            }
            if (var.getClass().isArray()) {
                this.bindArray(ctx, var);
            } else {
                ctx.addSql("?", var);
            }
        }
    }

    private void bindArray(CommandContext ctx, Object array) {
        int length = Array.getLength(array);
        if (length == 0) {
            return;
        }
        ctx.addSql("(");
        ctx.addSql("?", Array.get(array, 0));
        int i = 1;
        while (i < length) {
            ctx.addSql(", ?", Array.get(array, i));
            ++i;
        }
        ctx.addSql(")");
    }
}

