/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.mock.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.seasar.extension.mock.servlet.MockHeaderUtil;
import org.seasar.extension.mock.servlet.MockHttpServletResponse;
import org.seasar.extension.mock.servlet.MockServletOutputStreamImpl;
import org.seasar.framework.util.EmptyEnumeration;
import org.seasar.framework.util.EnumerationAdapter;
import org.seasar.framework.util.SPrintWriter;

public class MockHttpServletResponseImpl
implements MockHttpServletResponse {
    private List cookieList_;
    private Map headers_ = new HashMap();
    private boolean committed_ = false;
    private int status_;
    private String message_;
    private byte[] buffer_ = new byte[1024];
    private Locale locale_;
    private String characterEncoding_;
    private PrintWriter writer_ = new SPrintWriter();
    private ServletOutputStream outputStream_ = new MockServletOutputStreamImpl(this.writer_);

    public MockHttpServletResponseImpl(HttpServletRequest request) {
        this.cookieList_ = new ArrayList<Cookie>(Arrays.asList(request.getCookies()));
        this.locale_ = request.getLocale();
        this.characterEncoding_ = request.getCharacterEncoding();
    }

    public Cookie[] getCookies() {
        return this.cookieList_.toArray(new Cookie[this.cookieList_.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList_.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers_.containsKey(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectUrl(url);
    }

    public int getStatus() {
        return this.status_;
    }

    public String getMessage() {
        return this.message_;
    }

    public void sendError(int status, String message) throws IOException {
        this.setStatus(status, message);
    }

    public void sendError(int status) throws IOException {
        this.setStatus(status);
    }

    public void sendRedirect(String path) throws IOException {
    }

    public Enumeration getHeaders(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return new EnumerationAdapter(values.iterator());
        }
        return new EmptyEnumeration();
    }

    public String getHeader(String name) {
        List values = this.getHeaderList(name);
        if (values != null) {
            return (String)values.get(0);
        }
        return null;
    }

    public Enumeration getHeaderNames() {
        return new EnumerationAdapter(this.headers_.keySet().iterator());
    }

    public void setDateHeader(String name, long value) {
        this.setHeader(name, MockHeaderUtil.getDateValue(value));
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, MockHeaderUtil.getDateValue(value));
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers_.put(name.toLowerCase(), values);
    }

    public void addHeader(String name, String value) {
        ArrayList<String> values = this.getHeaderList(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers_.put(name.toLowerCase(), values);
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return MockHeaderUtil.getIntValue(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    private List getHeaderList(String name) {
        name = name.toLowerCase();
        return (List)this.headers_.get(name);
    }

    public void setStatus(int status) {
        this.setStatus(status, MockHttpServletResponseImpl.getResponseStatusMessage(status));
    }

    private static String getResponseStatusMessage(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + status;
    }

    public void setStatus(int status, String message) {
        this.assertNotCommitted();
        this.status_ = status;
        this.message_ = message;
        this.resetBuffer();
    }

    private void assertNotCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding_;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding_ = characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return this.outputStream_;
    }

    public PrintWriter getWriter() throws IOException {
        return this.writer_;
    }

    public void setContentLength(int contentLength) {
        this.setIntHeader("content-length", contentLength);
    }

    public int getContentLength() {
        return this.getIntHeader("content-length");
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public void setContentType(String contentType) {
        this.setHeader("content-type", contentType);
    }

    public void setBufferSize(int size) {
        this.assertNotCommitted();
        if (size <= this.buffer_.length) {
            return;
        }
        this.buffer_ = new byte[size];
    }

    public int getBufferSize() {
        return this.buffer_.length;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
        this.assertNotCommitted();
    }

    public boolean isCommitted() {
        return this.committed_;
    }

    public void reset() {
        this.committed_ = false;
    }

    public void setLocale(Locale locale) {
        this.locale_ = locale;
    }

    public Locale getLocale() {
        return this.locale_;
    }
}

