/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.auth.HttpAuthRealm;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.cookie.CookieSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpState {
    private HashMap credMap = new HashMap();
    private HashMap proxyCred = new HashMap();
    private ArrayList cookies = new ArrayList();
    private boolean preemptive = false;
    private int cookiePolicy = 0;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$HttpState == null ? (class$org$apache$commons$httpclient$HttpState = HttpState.class$("org.apache.commons.httpclient.HttpState")) : class$org$apache$commons$httpclient$HttpState));
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpState;

    public synchronized void addCookie(Cookie cookie) {
        LOG.trace((Object)"enter HttpState.addCookie(Cookie)");
        if (cookie != null) {
            Iterator it = ((AbstractList)this.cookies).iterator();
            while (it.hasNext()) {
                Cookie tmp = (Cookie)it.next();
                if (!cookie.equals(tmp)) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired()) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        LOG.trace((Object)"enter HttpState.addCookies(Cookie[])");
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                this.addCookie(cookies[i]);
                ++i;
            }
        }
    }

    public synchronized Cookie[] getCookies() {
        LOG.trace((Object)"enter HttpState.getCookies()");
        return this.cookies.toArray(new Cookie[this.cookies.size()]);
    }

    public synchronized Cookie[] getCookies(String domain, int port, String path, boolean secure) {
        LOG.trace((Object)"enter HttpState.getCookies(String, int, String, boolean)");
        CookieSpec matcher = CookiePolicy.getDefaultSpec();
        ArrayList<Cookie> list = new ArrayList<Cookie>(this.cookies.size());
        int i = 0;
        int m = this.cookies.size();
        while (i < m) {
            Cookie cookie = (Cookie)this.cookies.get(i);
            if (matcher.match(domain, port, path, secure, cookie)) {
                list.add(cookie);
            }
            ++i;
        }
        return list.toArray(new Cookie[list.size()]);
    }

    public synchronized boolean purgeExpiredCookies() {
        LOG.trace((Object)"enter HttpState.purgeExpiredCookies()");
        return this.purgeExpiredCookies(new Date());
    }

    public synchronized boolean purgeExpiredCookies(Date date) {
        LOG.trace((Object)"enter HttpState.purgeExpiredCookies(Date)");
        boolean removed = false;
        Iterator it = ((AbstractList)this.cookies).iterator();
        while (it.hasNext()) {
            if (!((Cookie)it.next()).isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public int getCookiePolicy() {
        return CookiePolicy.getDefaultPolicy();
    }

    public void setAuthenticationPreemptive(boolean value) {
        this.preemptive = value;
    }

    public boolean isAuthenticationPreemptive() {
        return this.preemptive;
    }

    public void setCookiePolicy(int policy) {
        this.cookiePolicy = policy;
    }

    public synchronized void setCredentials(String realm, String host, Credentials credentials) {
        LOG.trace((Object)"enter HttpState.setCredentials(String, String, Credentials)");
        this.credMap.put(new HttpAuthRealm(host, realm), credentials);
    }

    public synchronized void setCredentials(HttpAuthRealm realm, Credentials credentials) {
        if (realm == null) {
            throw new IllegalArgumentException("Authentication realm token may not be null");
        }
        LOG.trace((Object)"enter HttpState.setCredentials(HttpAuthRealm, Credentials)");
        this.credMap.put(realm, credentials);
    }

    private static Credentials matchCredentials(HashMap map, HttpAuthRealm token) {
        HttpAuthRealm key = token;
        Credentials creds = (Credentials)map.get(key);
        if (creds == null && token.getScheme() != null) {
            key = new HttpAuthRealm(token.getHost(), token.getPort(), token.getRealm());
            creds = (Credentials)map.get(key);
        }
        if (creds == null && token.getRealm() != null) {
            key = new HttpAuthRealm(token.getHost(), token.getPort());
            creds = (Credentials)map.get(key);
        }
        if (creds == null && token.getPort() >= 0) {
            key = new HttpAuthRealm(token.getHost(), -1);
            creds = (Credentials)map.get(key);
        }
        if (creds == null && token.getHost() != null) {
            key = new HttpAuthRealm();
            creds = (Credentials)map.get(key);
        }
        return creds;
    }

    public synchronized Credentials getCredentials(String realm, String host) {
        LOG.trace((Object)"enter HttpState.getCredentials(String, String");
        return HttpState.matchCredentials(this.credMap, new HttpAuthRealm(host, realm));
    }

    public synchronized Credentials getCredentials(HttpAuthRealm realm) {
        if (realm == null) {
            throw new IllegalArgumentException("Authentication realm token may not be null");
        }
        LOG.trace((Object)"enter HttpState.getCredentials(HttpAuthRealm)");
        return HttpState.matchCredentials(this.credMap, realm);
    }

    public synchronized void setProxyCredentials(String realm, String proxyHost, Credentials credentials) {
        LOG.trace((Object)"enter HttpState.setProxyCredentials(String, String, Credentials");
        this.proxyCred.put(new HttpAuthRealm(proxyHost, realm), credentials);
    }

    public synchronized void setProxyCredentials(HttpAuthRealm realm, Credentials credentials) {
        if (realm == null) {
            throw new IllegalArgumentException("Authentication realm token may not be null");
        }
        LOG.trace((Object)"enter HttpState.setProxyCredentials(HttpAuthRealm, Credentials)");
        this.proxyCred.put(realm, credentials);
    }

    public synchronized Credentials getProxyCredentials(String realm, String proxyHost) {
        LOG.trace((Object)"enter HttpState.getCredentials(String, String");
        return HttpState.matchCredentials(this.proxyCred, new HttpAuthRealm(proxyHost, realm));
    }

    public synchronized Credentials getProxyCredentials(HttpAuthRealm realm) {
        if (realm == null) {
            throw new IllegalArgumentException("Authentication realm token may not be null");
        }
        LOG.trace((Object)"enter HttpState.getProxyCredentials(HttpAuthRealm)");
        return HttpState.matchCredentials(this.proxyCred, realm);
    }

    public synchronized String toString() {
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("[");
        sbResult.append(HttpState.getCredentialsStringRepresentation(this.proxyCred));
        sbResult.append(" | ");
        sbResult.append(HttpState.getCredentialsStringRepresentation(this.credMap));
        sbResult.append(" | ");
        sbResult.append(HttpState.getCookiesStringRepresentation(this.cookies));
        sbResult.append("]");
        String strResult = sbResult.toString();
        return strResult;
    }

    private static String getCredentialsStringRepresentation(Map credMap) {
        StringBuffer sbResult = new StringBuffer();
        Iterator iter = credMap.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Credentials cred = (Credentials)credMap.get(key);
            if (sbResult.length() > 0) {
                sbResult.append(", ");
            }
            sbResult.append(key);
            sbResult.append("#");
            sbResult.append(cred.toString());
        }
        return sbResult.toString();
    }

    private static String getCookiesStringRepresentation(List cookies) {
        StringBuffer sbResult = new StringBuffer();
        Iterator iter = cookies.iterator();
        while (iter.hasNext()) {
            Cookie ck = (Cookie)iter.next();
            if (sbResult.length() > 0) {
                sbResult.append("#");
            }
            sbResult.append(ck.toExternalForm());
        }
        return sbResult.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

