/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class RemappingCodeVisitor
extends CodeAdapter {
    private State state;
    private IntRef check = new IntRef();

    public RemappingCodeVisitor(CodeVisitor v, int access, Type[] args) {
        super(v);
        this.state = new State(access, args);
    }

    public RemappingCodeVisitor(RemappingCodeVisitor wrap) {
        super(wrap.cv);
        this.state = wrap.state;
    }

    protected int nextLocal(int size) {
        int var = this.state.nextLocal;
        this.state.nextLocal += size;
        return var;
    }

    private int remap(int var, int size) {
        if (var < this.state.firstLocal) {
            return var;
        }
        this.check.key = size == 2 ? ~var : var;
        Integer value = (Integer)this.state.locals.get(this.check);
        if (value == null) {
            IntRef ref = new IntRef();
            ref.key = this.check.key;
            value = new Integer(this.nextLocal(size));
            this.state.locals.put(ref, value);
        }
        return value;
    }

    public void visitIincInsn(int var, int increment) {
        this.cv.visitIincInsn(this.remap(var, 1), increment);
    }

    public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        this.cv.visitLocalVariable(name, desc, start, end, this.remap(index, 0));
    }

    public void visitVarInsn(int opcode, int var) {
        int size;
        switch (opcode) {
            case 22: 
            case 24: 
            case 55: 
            case 57: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        this.cv.visitVarInsn(opcode, this.remap(var, size));
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.cv.visitMaxs(0, 0);
    }

    private static class IntRef {
        int key;

        private IntRef() {
        }

        public boolean equals(Object o) {
            return this.key == ((IntRef)o).key;
        }

        public int hashCode() {
            return this.key;
        }
    }

    private static class State {
        Map locals = new HashMap();
        int firstLocal;
        int nextLocal;

        State(int access, Type[] args) {
            this.nextLocal = (8 & access) != 0 ? 0 : 1;
            for (int i = 0; i < args.length; ++i) {
                this.nextLocal += args[i].getSize();
            }
            this.firstLocal = this.nextLocal;
        }
    }
}

