/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.tree;

import java.util.Iterator;
import java.util.List;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import net.sourceforge.myfaces.custom.tree.HtmlTree;
import net.sourceforge.myfaces.custom.tree.HtmlTreeImageCommandLink;
import net.sourceforge.myfaces.custom.tree.model.TreeModel;
import net.sourceforge.myfaces.custom.tree.model.TreePath;

public class HtmlTreeNode
extends HtmlCommandLink {
    private static final String DEFAULT_RENDERER_TYPE = "net.sourceforge.myfaces.HtmlTreeNode";
    public static final String COMPONENT_TYPE = "net.sourceforge.myfaces.HtmlTreeNode";
    public static final String EXPAND_COLLAPSE_FACET = "expandCollapse";
    public static final int OPEN = 0;
    public static final int OPEN_FIRST = 1;
    public static final int OPEN_LAST = 2;
    public static final int OPEN_SINGLE = 3;
    public static final int CLOSED = 10;
    public static final int CLOSED_FIRST = 11;
    public static final int CLOSED_LAST = 12;
    public static final int CLOSED_SINGLE = 13;
    public static final int CHILD = 20;
    public static final int CHILD_FIRST = 21;
    public static final int CHILD_LAST = 22;
    public static final int CHILD_SINGLE = 23;
    public static final int LINE = 30;
    public static final int EMPTY = 40;
    private static final int OFFSET = 10;
    private static final int MOD_FIRST = 1;
    private static final int MOD_LAST = 2;
    private transient TreePath path;
    private int[] translatedPath;
    private transient Object userObject;
    private boolean expanded = false;
    private boolean selected = false;
    private int[] layout;

    public HtmlTreeNode() {
        this.setRendererType("net.sourceforge.myfaces.HtmlTreeNode");
    }

    public int getLevel() {
        return this.layout.length - 1;
    }

    public int getMaxChildLevel() {
        if (this.getChildCount() == 0) {
            return this.getLevel();
        }
        int max = this.getLevel();
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)iterator.next());
            max = Math.max(max, child.getMaxChildLevel());
        }
        return max;
    }

    public TreePath getPath() {
        if (this.path == null) {
            if (this.translatedPath == null) {
                throw new IllegalStateException("No path and no translated path available");
            }
            this.path = HtmlTreeNode.translatePath(this.translatedPath, this.getTreeModel(FacesContext.getCurrentInstance()));
        }
        return this.path;
    }

    public void setPath(TreePath path) {
        this.path = path;
    }

    int[] getTranslatedPath() {
        if (this.translatedPath != null) {
            return this.translatedPath;
        }
        return HtmlTreeNode.translatePath(this.getPath(), this.getTreeModel(FacesContext.getCurrentInstance()));
    }

    public Object getUserObject() {
        if (this.userObject == null) {
            this.userObject = this.getPath().getLastPathComponent();
        }
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
        this.setValue(userObject.toString());
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    void childrenAdded(int[] children, FacesContext context) {
        if (this.getChildCount() == 0 && children.length > 0) {
            int n = this.layout.length - 1;
            this.layout[n] = this.layout[n] - 10;
        }
        if (!this.expanded) {
            return;
        }
        TreeModel model = this.getTreeModel(context);
        int childCount = model.getChildCount(this.getUserObject());
        int pathUpdateIndex = this.getTranslatedPath().length;
        for (int i = 0; i < children.length; ++i) {
            int index = children[i];
            this.translateChildrenPath(pathUpdateIndex, index, 1);
            Object userObject = model.getChild(this.getUserObject(), index);
            this.addNode(model, userObject, index, childCount, context);
        }
    }

    void childrenChanged(int[] children, FacesContext context) {
        if (!this.expanded) {
            return;
        }
        TreeModel model = this.getTreeModel(context);
        for (int i = 0; i < children.length; ++i) {
            int index = children[i];
            Object userObject = model.getChild(this.getUserObject(), index);
            HtmlTreeNode node = (HtmlTreeNode)((Object)this.getChildren().get(index));
            node.setUserObject(userObject);
        }
    }

    private void addNode(TreeModel model, Object userObject, int index, int childCount, FacesContext context) {
        HtmlTreeNode node = this.createNode(model, userObject, childCount, index, context);
        List children = this.getChildren();
        if (!children.isEmpty()) {
            HtmlTreeNode last;
            int[] layout;
            if (index == 0) {
                HtmlTreeNode first = (HtmlTreeNode)((Object)this.getChildren().get(0));
                int[] layout2 = first.getLayout();
                if (layout2[layout2.length - 1] % 10 == 1) {
                    int n = layout2.length - 1;
                    layout2[n] = layout2[n] - 1;
                }
            } else if (index == childCount - 1 && (layout = (last = (HtmlTreeNode)((Object)this.getChildren().get(childCount - 2))).getLayout())[layout.length - 1] % 10 == 2) {
                int n = layout.length - 1;
                layout[n] = layout[n] - 2;
            }
        }
        children.add(index, node);
    }

    void childrenRemoved(int[] children) {
        if (!this.expanded) {
            return;
        }
        List childNodes = this.getChildren();
        int pathUpdateIndex = this.getTranslatedPath().length;
        for (int i = children.length - 1; i >= 0; --i) {
            this.translateChildrenPath(pathUpdateIndex, children[i], -1);
            HtmlTreeNode child = (HtmlTreeNode)((Object)childNodes.get(children[i]));
            if (child.isSelected()) {
                child.setSelected(false);
                if (children[i] < childNodes.size() - 1) {
                    ((HtmlTreeNode)((Object)childNodes.get(children[i] + 1))).setSelected(true);
                } else if (children[i] > 0) {
                    ((HtmlTreeNode)((Object)childNodes.get(children[i] - 1))).setSelected(true);
                } else {
                    this.setSelected(true);
                }
            }
            childNodes.remove(children[i]);
        }
    }

    private void translateChildrenPath(int pathUpdateIndex, int startIndex, int offset) {
        List children = this.getChildren();
        int childrenSize = children.size();
        for (int i = startIndex; i < childrenSize; ++i) {
            HtmlTreeNode node = (HtmlTreeNode)((Object)children.get(i));
            node.updateTranslatedPath(pathUpdateIndex, offset);
        }
    }

    private void updateTranslatedPath(int pathUpdateIndex, int offset) {
        int n = pathUpdateIndex;
        this.translatedPath[n] = this.translatedPath[n] + offset;
        this.path = null;
        this.userObject = null;
        if (this.isExpanded()) {
            this.translateChildrenPath(pathUpdateIndex, 0, offset);
        }
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded == expanded) {
            return;
        }
        this.expanded = expanded;
        if (expanded) {
            FacesContext context = FacesContext.getCurrentInstance();
            TreeModel model = this.getTreeModel(context);
            int childCount = model.getChildCount(this.getUserObject());
            for (int i = 0; i < childCount; ++i) {
                Object child = model.getChild(this.getUserObject(), i);
                HtmlTreeNode node = this.createNode(model, child, childCount, i, context);
                this.getChildren().add(node);
            }
            int n = this.layout.length - 1;
            this.layout[n] = this.layout[n] - 10;
        } else {
            if (this.clearSelection()) {
                this.setSelected(true);
            }
            this.getChildren().clear();
            int n = this.layout.length - 1;
            this.layout[n] = this.layout[n] + 10;
        }
    }

    private HtmlTreeNode createNode(TreeModel model, Object child, int childCount, int index, FacesContext context) {
        HtmlTreeNode node = (HtmlTreeNode)context.getApplication().createComponent("net.sourceforge.myfaces.HtmlTreeNode");
        String id = this.getTree().createUniqueId(context);
        node.setId(id);
        node.setPath(this.getPath().pathByAddingChild(child));
        node.setUserObject(child);
        int state = 20;
        int childChildCount = model.getChildCount(child);
        if (childChildCount == 0) {
            if (childCount > 1) {
                if (index == 0) {
                    state = 20;
                } else if (index == childCount - 1) {
                    state = 22;
                }
            } else {
                state = 22;
            }
        } else {
            state = childCount > 1 ? (index == 0 ? 10 : (index == childCount - 1 ? 12 : 10)) : 12;
        }
        node.setLayout(this.layout, state);
        return node;
    }

    public void toggleExpanded() {
        this.setExpanded(!this.expanded);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.getTree().getRootNode().clearSelection();
        }
        this.selected = selected;
        this.getTree().selectionChanged(this);
    }

    public void toggleSelected() {
        this.setSelected(!this.selected);
    }

    private boolean clearSelection() {
        if (this.isSelected()) {
            this.selected = false;
            return true;
        }
        Iterator iterator = this.getChildren().iterator();
        while (iterator.hasNext()) {
            HtmlTreeNode node = (HtmlTreeNode)((Object)iterator.next());
            if (!node.clearSelection()) continue;
            return true;
        }
        return false;
    }

    public int[] getLayout() {
        return this.layout;
    }

    public void setLayout(int[] layout) {
        this.layout = layout;
    }

    public void setLayout(int[] parentLayout, int layout) {
        this.layout = new int[parentLayout.length + 1];
        this.layout[parentLayout.length] = layout;
        for (int i = 0; i < parentLayout.length; ++i) {
            int state = parentLayout[i];
            this.layout[i] = state == 0 || state == 1 || state == 10 || state == 11 || state == 20 || state == 21 || state == 30 ? 30 : 40;
        }
    }

    public HtmlTreeImageCommandLink getExpandCollapseCommand(FacesContext context) {
        HtmlTreeImageCommandLink command = (HtmlTreeImageCommandLink)this.getFacet(EXPAND_COLLAPSE_FACET);
        if (command == null) {
            command = (HtmlTreeImageCommandLink)context.getApplication().createComponent("net.sourceforge.myfaces.HtmlTreeImageCommandLink");
            String id = this.getTree().createUniqueId(context);
            command.setId(id);
            this.getFacets().put(EXPAND_COLLAPSE_FACET, command);
        }
        return command;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.expanded, this.layout, HtmlTreeNode.translatePath(this.getPath(), this.getTreeModel(context)), this.selected};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.expanded = (Boolean)values[1];
        this.layout = (int[])values[2];
        this.translatedPath = (int[])values[3];
        this.selected = (Boolean)values[4];
    }

    protected static int[] translatePath(TreePath treePath, TreeModel model) {
        Object[] path = treePath.getPath();
        int[] translated = new int[path.length - 1];
        Object parent = path[0];
        for (int i = 1; i < path.length; ++i) {
            Object element = path[i];
            translated[i - 1] = model.getIndexOfChild(parent, element);
            parent = element;
        }
        return translated;
    }

    protected static TreePath translatePath(int[] path, TreeModel model) {
        Object parent;
        Object[] translated = new Object[path.length + 1];
        translated[0] = parent = model.getRoot();
        for (int i = 0; i < path.length; ++i) {
            int index = path[i];
            translated[i + 1] = model.getChild(parent, index);
            parent = translated[i + 1];
        }
        return new TreePath(translated);
    }

    protected TreeModel getTreeModel(FacesContext context) {
        return this.getTree().getModel(context);
    }

    protected HtmlTree getTree() {
        if (this.getParent() instanceof HtmlTree) {
            return (HtmlTree)this.getParent();
        }
        return ((HtmlTreeNode)this.getParent()).getTree();
    }

    public boolean isLeaf(FacesContext context) {
        return this.getTreeModel(context).isLeaf(this.getUserObject());
    }

    public void expandPath(int[] translatedPath, int current) {
        if (current >= translatedPath.length) {
            return;
        }
        HtmlTreeNode child = (HtmlTreeNode)((Object)this.getChildren().get(translatedPath[current]));
        if (!child.isExpanded()) {
            child.setExpanded(true);
        }
        child.expandPath(translatedPath, current + 1);
    }

    public void restoreItemState(HtmlTreeNode node) {
        this.setExpanded(node.isExpanded());
        this.selected = node.isSelected();
        List children = this.getChildren();
        List otherChildren = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            HtmlTreeNode child = (HtmlTreeNode)((Object)children.get(i));
            child.restoreItemState((HtmlTreeNode)((Object)otherChildren.get(i)));
        }
    }
}

