/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlPanelGrid;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import net.sourceforge.myfaces.renderkit.RendererUtils;
import net.sourceforge.myfaces.renderkit.html.HTML;
import net.sourceforge.myfaces.renderkit.html.HtmlRenderer;
import net.sourceforge.myfaces.renderkit.html.HtmlRendererUtils;
import net.sourceforge.myfaces.util.ArrayUtils;
import net.sourceforge.myfaces.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HtmlGridRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$renderkit$html$HtmlGridRenderer == null ? (class$net$sourceforge$myfaces$renderkit$html$HtmlGridRenderer = HtmlGridRenderer.class$("net.sourceforge.myfaces.renderkit.html.HtmlGridRenderer")) : class$net$sourceforge$myfaces$renderkit$html$HtmlGridRenderer));
    static /* synthetic */ Class class$net$sourceforge$myfaces$renderkit$html$HtmlGridRenderer;
    static /* synthetic */ Class class$javax$faces$component$UIPanel;

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        int columns;
        RendererUtils.checkParamValidity(facesContext, component, class$javax$faces$component$UIPanel == null ? (class$javax$faces$component$UIPanel = HtmlGridRenderer.class$("javax.faces.component.UIPanel")) : class$javax$faces$component$UIPanel);
        if (component instanceof HtmlPanelGrid) {
            columns = ((HtmlPanelGrid)component).getColumns();
        } else {
            Integer i = (Integer)component.getAttributes().get("columns");
            int n = columns = i != null ? i : 0;
        }
        if (columns <= 0) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Wrong columns attribute for PanelGrid " + component.getClientId(facesContext) + ": " + columns));
            }
            columns = 1;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", component);
        HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
        writer.flush();
        this.renderHeaderOrFooter(facesContext, writer, component, columns, true);
        this.renderChildren(facesContext, writer, component, columns);
        this.renderHeaderOrFooter(facesContext, writer, component, columns, false);
        writer.endElement("table");
    }

    private void renderHeaderOrFooter(FacesContext context, ResponseWriter writer, UIComponent component, int columns, boolean header) throws IOException {
        String styleClass;
        UIComponent facet = component.getFacet(header ? "header" : "footer");
        if (facet == null) {
            return;
        }
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.startElement(header ? "thead" : "tfoot", component);
        writer.startElement("tr", component);
        writer.startElement(header ? "th" : "td", component);
        String string = component instanceof HtmlPanelGrid ? (header ? ((HtmlPanelGrid)component).getHeaderClass() : ((HtmlPanelGrid)component).getFooterClass()) : (styleClass = header ? (String)component.getAttributes().get("headerClass") : (String)component.getAttributes().get("footerClass"));
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, header ? "headerClass" : "footerClass");
        }
        if (header) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        writer.writeAttribute("colspan", (Object)Integer.toString(columns), null);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        RendererUtils.renderChild(context, facet);
        HtmlRendererUtils.writePrettyLineSeparator(context);
        writer.endElement(header ? "th" : "td");
        writer.endElement("tr");
        writer.endElement(header ? "thead" : "tfoot");
    }

    private void renderChildren(FacesContext context, ResponseWriter writer, UIComponent component, int columns) throws IOException {
        String rowClasses;
        String columnClasses;
        writer.startElement("tbody", component);
        if (component instanceof HtmlPanelGrid) {
            columnClasses = ((HtmlPanelGrid)component).getColumnClasses();
            rowClasses = ((HtmlPanelGrid)component).getRowClasses();
        } else {
            columnClasses = (String)component.getAttributes().get("columnClasses");
            rowClasses = (String)component.getAttributes().get("rowClasses");
        }
        String[] columnClassesArray = columnClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnClasses, ','));
        int columnClassesCount = columnClassesArray.length;
        String[] rowClassesArray = rowClasses == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowClasses, ','));
        int rowClassesCount = rowClassesArray.length;
        int childCount = component.getChildCount();
        if (childCount > 0) {
            int columnIndex = 0;
            int rowClassIndex = 0;
            boolean rowStarted = false;
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                if (!child.isRendered()) continue;
                if (columnIndex == 0) {
                    if (rowStarted) {
                        writer.endElement("tr");
                        HtmlRendererUtils.writePrettyLineSeparator(context);
                    }
                    writer.startElement("tr", component);
                    if (rowClassIndex < rowClassesCount) {
                        writer.writeAttribute("class", (Object)rowClassesArray[rowClassIndex], null);
                    }
                    rowStarted = true;
                    if (++rowClassIndex == rowClassesCount) {
                        rowClassIndex = 0;
                    }
                }
                writer.startElement("td", component);
                if (columnIndex < columnClassesCount) {
                    writer.writeAttribute("class", (Object)columnClassesArray[columnIndex], null);
                }
                RendererUtils.renderChild(context, child);
                writer.endElement("td");
                if (++columnIndex < columns) continue;
                columnIndex = 0;
            }
            if (rowStarted) {
                if (columnIndex > 0) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("PanelGrid " + component.getClientId(context) + " has not enough children. Child count should be a multiple of the columns attribute."));
                    }
                    while (columnIndex < columns) {
                        writer.startElement("td", component);
                        if (columnIndex < columnClassesCount) {
                            writer.writeAttribute("class", (Object)columnClassesArray[columnIndex], null);
                        }
                        writer.endElement("td");
                        ++columnIndex;
                    }
                }
                writer.endElement("tr");
                HtmlRendererUtils.writePrettyLineSeparator(context);
            }
        }
        writer.endElement("tbody");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

