/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.TagConfig;
import org.seasar.jsf.TaglibConfig;
import org.seasar.jsf.TaglibManager;
import org.seasar.jsf.exception.PrefixNotFoundRuntimeException;
import org.seasar.jsf.exception.UriNotFoundRuntimeException;

public class JsfConfigImpl
implements JsfConfig {
    private Map taglibUris = new HashMap();
    private Map prefixes = new HashMap();
    private TaglibManager taglibManager;

    public void addTaglibUri(String prefix, String uri) {
        this.taglibUris.put(prefix, uri);
        this.prefixes.put(uri, prefix);
    }

    public boolean hasTaglibUri(String prefix) {
        return this.taglibUris.containsKey(prefix);
    }

    public String getTaglibUri(String prefix) {
        String uri = (String)this.taglibUris.get(prefix);
        if (uri != null) {
            return uri;
        }
        throw new PrefixNotFoundRuntimeException(prefix);
    }

    public String getTaglibPrefix(String uri) {
        String prefix = (String)this.prefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        throw new UriNotFoundRuntimeException(uri);
    }

    public TagConfig getTagConfig(String prefix, String tagName) {
        String uri = this.getTaglibUri(prefix);
        TaglibConfig taglibConfig = this.getTaglibManager().getTaglibConfig(uri);
        return taglibConfig.getTagConfig(tagName);
    }

    public TagConfig getTagConfig(String inject) {
        int index = inject.indexOf(58);
        if (index < 0) {
            throw new IllegalArgumentException(inject);
        }
        String prefix = inject.substring(0, index);
        String tagName = inject.substring(index + 1);
        return this.getTagConfig(prefix, tagName);
    }

    public TaglibManager getTaglibManager() {
        if (this.taglibManager != null) {
            return this.taglibManager;
        }
        throw new EmptyRuntimeException("taglibManager");
    }

    public void setTaglibManager(TaglibManager taglibManager) {
        this.taglibManager = taglibManager;
    }
}

