/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.remoting.axis.deployer;

import javax.servlet.ServletContext;
import org.apache.axis.AxisEngine;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.remoting.axis.DeployFailedException;
import org.seasar.remoting.axis.deployer.HandlerDeployer;
import org.seasar.remoting.axis.deployer.ItemDeployer;
import org.seasar.remoting.axis.deployer.ServiceDeployer;
import org.seasar.remoting.axis.deployer.WSDDDeployer;
import org.seasar.remoting.common.deployer.Deployer;

public class AxisDeployer
implements Deployer {
    protected S2Container container;
    protected ServletContext servletContext;
    protected ItemDeployer serviceDeployer = new ServiceDeployer(this);
    protected ItemDeployer handlerDeployer = new HandlerDeployer(this);
    protected ItemDeployer wsddDeployer = new WSDDDeployer(this);
    static /* synthetic */ Class class$0;

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void deploy() {
        this.forEach(this.container.getRoot());
    }

    protected void forEach(S2Container container) {
        this.process(container);
        int componentDefSize = container.getComponentDefSize();
        int i = 0;
        while (i < componentDefSize) {
            this.process(container.getComponentDef(i));
            ++i;
        }
        int childContainerSize = container.getChildSize();
        int i2 = 0;
        while (i2 < childContainerSize) {
            this.forEach(container.getChild(i2));
            ++i2;
        }
    }

    protected void process(S2Container container) {
        MetaDef[] metaDefs = container.getMetaDefs("s2-axis:deploy");
        int i = 0;
        while (metaDefs != null && i < metaDefs.length) {
            this.wsddDeployer.deploy(null, metaDefs[i]);
            ++i;
        }
    }

    protected void process(ComponentDef componentDef) {
        MetaDef handlerMetaDef;
        MetaDef serviceMetaDef = componentDef.getMetaDef("s2-axis:service");
        if (serviceMetaDef != null) {
            this.serviceDeployer.deploy(componentDef, serviceMetaDef);
        }
        if ((handlerMetaDef = componentDef.getMetaDef("s2-axis:handler")) != null) {
            this.handlerDeployer.deploy(componentDef, handlerMetaDef);
        }
    }

    protected WSDDDeployment getDeployment(S2Container container) {
        return ((WSDDEngineConfiguration)this.getEngine(container).getConfig()).getDeployment();
    }

    protected AxisEngine getEngine(S2Container container) {
        String engineName = "default";
        MetaDef metadata = container.getMetaDef("s2-axis:engine");
        if (metadata != null) {
            engineName = (String)metadata.getValue();
        }
        if ("default".equals(engineName)) {
            engineName = this.servletContext == null ? "default-client" : "default-server";
        }
        AxisEngine engine = null;
        if ("default-client".equals(engineName)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.xml.rpc.Service");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Service service = (Service)container.getComponent((Object)clazz);
            engine = service.getEngine();
        } else {
            engine = "default-server".equals(engineName) ? (AxisEngine)this.servletContext.getAttribute("AxisEngine") : (AxisEngine)container.getComponent((Object)engineName);
        }
        if (engine == null) {
            throw new DeployFailedException(MessageFormatter.getSimpleMessage((String)"EAXS0007", null));
        }
        return engine;
    }
}

