/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.timer;

import org.seasar.extension.timer.TimeoutTarget;
import org.seasar.framework.exception.SIllegalStateException;

public class TimeoutTask {
    private static final int ACTIVE = 0;
    private static final int STOPPED = 1;
    private static final int CANCELED = 2;
    private final TimeoutTarget timeoutTarget_;
    private final long timeoutMillis_;
    private final boolean permanent_;
    private long startTime_;
    private int status_ = 0;

    TimeoutTask(TimeoutTarget timeoutTarget, int timeout, boolean permanent) {
        this.timeoutTarget_ = timeoutTarget;
        this.timeoutMillis_ = timeout * 1000;
        this.permanent_ = permanent;
        this.startTime_ = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() >= this.startTime_ + this.timeoutMillis_;
    }

    public boolean isPermanent() {
        return this.permanent_;
    }

    public boolean isCanceled() {
        return this.status_ == 2;
    }

    public void cancel() {
        this.status_ = 2;
    }

    public boolean isStopped() {
        return this.status_ == 1;
    }

    public void stop() {
        if (this.status_ != 0) {
            throw new SIllegalStateException("ESSR0026", new Object[]{String.valueOf(this.status_)});
        }
        this.status_ = 1;
    }

    public void restart() {
        this.status_ = 0;
        this.startTime_ = System.currentTimeMillis();
    }

    void expired() {
        this.timeoutTarget_.expired();
    }
}

