/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataSetConstants;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.DataWriter;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.FileOutputStreamUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringConversionUtil;

public class XlsWriter
implements DataWriter,
DataSetConstants {
    private OutputStream out_;
    private HSSFWorkbook workbook_;
    private HSSFCellStyle dateStyle_;
    private HSSFCellStyle base64Style_;

    public XlsWriter(String path) {
        File file = new File(ResourceUtil.getResourceAsFile((String)"."), path);
        this.setOutputStream(FileOutputStreamUtil.create((File)file));
    }

    public XlsWriter(OutputStream out) {
        this.setOutputStream(out);
    }

    public void setOutputStream(OutputStream out) {
        this.out_ = out;
        this.workbook_ = new HSSFWorkbook();
        HSSFDataFormat df = this.workbook_.createDataFormat();
        this.dateStyle_ = this.workbook_.createCellStyle();
        this.dateStyle_.setDataFormat(df.getFormat("yyyy/MM/dd"));
        this.base64Style_ = this.workbook_.createCellStyle();
        this.base64Style_.setDataFormat(df.getFormat("\\B\\:@"));
    }

    public void write(DataSet dataSet) {
        int i = 0;
        while (i < dataSet.getTableSize()) {
            DataTable table = dataSet.getTable(i);
            HSSFSheet sheet = this.workbook_.createSheet();
            this.workbook_.setSheetName(i, table.getTableName(), (short)1);
            HSSFRow headerRow = sheet.createRow(0);
            int j = 0;
            while (j < table.getColumnSize()) {
                HSSFCell cell = headerRow.createCell((short)j);
                cell.setCellValue(table.getColumnName(j));
                ++j;
            }
            j = 0;
            while (j < table.getRowSize()) {
                HSSFRow row = sheet.createRow(j + 1);
                int k = 0;
                while (k < table.getColumnSize()) {
                    DataRow dataRow = table.getRow(j);
                    Object value = dataRow.getValue(k);
                    if (value != null) {
                        HSSFCell cell = row.createCell((short)k);
                        this.setValue(cell, value);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        try {
            this.workbook_.write(this.out_);
            this.out_.flush();
            this.out_.close();
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
    }

    private void setValue(HSSFCell cell, Object value) {
        if (value instanceof Number) {
            cell.setCellValue(((Number)value).doubleValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
            cell.setCellStyle(this.dateStyle_);
        } else if (value instanceof byte[]) {
            cell.setCellValue(Base64Util.encode((byte[])((byte[])value)));
            cell.setCellStyle(this.base64Style_);
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else {
            cell.setEncoding((short)1);
            cell.setCellValue(StringConversionUtil.toString((Object)value, null));
        }
    }
}

