/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRenderer;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlLabelRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlLabelRenderer == null ? (class$org$apache$myfaces$renderkit$html$HtmlLabelRenderer = HtmlLabelRenderer.class$("org.apache.myfaces.renderkit.html.HtmlLabelRenderer")) : class$org$apache$myfaces$renderkit$html$HtmlLabelRenderer));
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlLabelRenderer;

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String text;
        super.encodeBegin(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("label", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.LABEL_PASSTHROUGH_ATTRIBUTES);
        String forAttr = this.getFor(uiComponent);
        if (forAttr == null) {
            throw new NullPointerException("Attribute 'for' of label component with id " + uiComponent.getClientId(facesContext));
        }
        UIComponent forComponent = uiComponent.findComponent(forAttr);
        if (forComponent == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Unable to find component '" + forAttr + "' (calling findComponent on component '" + uiComponent.getClientId(facesContext) + "')"));
            }
            if (forAttr.length() > 0 && forAttr.charAt(0) == ':') {
                writer.writeAttribute("for", forAttr.substring(1), "for");
            } else {
                String labelClientId = uiComponent.getClientId(facesContext);
                int colon = labelClientId.lastIndexOf(58);
                if (colon == -1) {
                    writer.writeAttribute("for", forAttr, "for");
                } else {
                    writer.writeAttribute("for", labelClientId.substring(0, colon + 1) + forAttr, "for");
                }
            }
        } else {
            writer.writeAttribute("for", forComponent.getClientId(facesContext), "for");
        }
        if (uiComponent instanceof ValueHolder && (text = RendererUtils.getStringValue(facesContext, uiComponent)) != null) {
            writer.writeText(text, "value");
        }
        writer.flush();
    }

    protected String getFor(UIComponent component) {
        if (component instanceof HtmlOutputLabel) {
            return ((HtmlOutputLabel)component).getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeEnd(facesContext, uiComponent);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("label");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

