/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.BatchHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.PreparedStatementUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicBatchHandler
extends BasicHandler
implements BatchHandler {
    private static Logger logger_;
    private int batchSize_ = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.extension.jdbc.impl.BasicBatchHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public BasicBatchHandler() {
    }

    public BasicBatchHandler(DataSource dataSource, String sql, int batchSize) {
        this(dataSource, sql, batchSize, BasicStatementFactory.INSTANCE);
    }

    public BasicBatchHandler(DataSource dataSource, String sql, int batchSize, StatementFactory statementFactory) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setBatchSize(batchSize);
        this.setStatementFactory(statementFactory);
    }

    public int getBatchSize() {
        return this.batchSize_;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize_ = batchSize;
    }

    public int execute(List list) throws SQLRuntimeException {
        if (list.size() == 0) {
            return 0;
        }
        Object[] args = (Object[])list.get(0);
        return this.execute(list, this.getArgTypes(args));
    }

    public int execute(List list, Class[] argTypes) throws SQLRuntimeException {
        int n;
        Connection connection = this.getConnection();
        try {
            n = this.execute(connection, list, argTypes);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            ConnectionUtil.close((Connection)connection);
            throw throwable;
        }
        ConnectionUtil.close((Connection)connection);
        return n;
    }

    protected int execute(Connection connection, List list, Class[] argTypes) {
        int n;
        PreparedStatement ps = this.prepareStatement(connection);
        int batchSize = this.batchSize_ > 0 ? this.batchSize_ : list.size();
        try {
            int i = 0;
            int j = 0;
            while (i < list.size()) {
                Object[] args = (Object[])list.get(i);
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)this.getCompleteSql(args));
                }
                this.bindArgs(ps, args, argTypes);
                PreparedStatementUtil.addBatch((PreparedStatement)ps);
                if (j == batchSize - 1 || i == list.size() - 1) {
                    PreparedStatementUtil.executeBatch((PreparedStatement)ps);
                    j = 0;
                } else {
                    ++j;
                }
                ++i;
            }
            n = list.size();
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            StatementUtil.close((Statement)ps);
            throw throwable;
        }
        StatementUtil.close((Statement)ps);
        return n;
    }
}

