/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.ReferenceSyntaxException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ArraySuffix;
import org.apache.commons.el.BinaryOperatorExpression;
import org.apache.commons.el.Coercions;
import org.apache.commons.el.ComplexValue;
import org.apache.commons.el.ConditionalExpression;
import org.apache.commons.el.Expression;
import org.apache.commons.el.ExpressionString;
import org.apache.commons.el.FunctionInvocation;
import org.apache.commons.el.Literal;
import org.apache.commons.el.Logger;
import org.apache.commons.el.NamedValue;
import org.apache.commons.el.PropertySuffix;
import org.apache.commons.el.UnaryOperatorExpression;
import org.apache.commons.el.ValueSuffix;
import org.apache.commons.el.parser.ELParser;
import org.apache.commons.el.parser.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.util.StringUtils;

public class ELParserHelper {
    static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$el$ELParserHelper == null ? (class$org$apache$myfaces$el$ELParserHelper = ELParserHelper.class$("org.apache.myfaces.el.ELParserHelper")) : class$org$apache$myfaces$el$ELParserHelper));
    public static final Logger LOGGER = new Logger(System.out);
    static /* synthetic */ Class class$org$apache$myfaces$el$ELParserHelper;

    private ELParserHelper() {
    }

    public static Object parseExpression(String expressionString) {
        expressionString = ELParserHelper.toJspElExpression(expressionString);
        ELParser parser = new ELParser((Reader)new StringReader(expressionString));
        try {
            Object expression = parser.ExpressionString();
            if (!(expression instanceof Expression) && !(expression instanceof ExpressionString)) {
                throw new ReferenceSyntaxException("Invalid expression: '" + expressionString + "'. Parsed Expression of unexpected type " + expression.getClass().getName());
            }
            ELParserHelper.replaceSuffixes(expression);
            return expression;
        }
        catch (ParseException e) {
            String msg = "Invalid expression: '" + expressionString + "'";
            log.debug((Object)msg, (Throwable)e);
            throw new ReferenceSyntaxException(msg, e);
        }
    }

    /*
     * Unable to fully structure code
     */
    static String toJspElExpression(String expressionString) {
        sb = new StringBuffer(expressionString.length());
        oldPos = 0;
        pos = expressionString.indexOf(123);
        while (pos >= 0) {
            sb.append(expressionString.substring(oldPos, pos - 1));
            if (pos <= 0) ** GOTO lbl-1000
            if (expressionString.charAt(pos - 1) == '$') {
                sb.append("${'${'}");
            } else if (expressionString.charAt(pos - 1) == '#') {
                sb.append("${");
                oldPos = pos + 1;
                pos = ELParserHelper.indexOfMatchingClosingBrace(expressionString, pos);
                sb.append(expressionString.substring(oldPos, pos + 1));
            } else lbl-1000:
            // 2 sources

            {
                sb.append('{');
            }
            oldPos = pos + 1;
            pos = expressionString.indexOf(123, oldPos);
        }
        return new String(sb.append(expressionString.substring(oldPos)).toString());
    }

    private static int findQuote(String expressionString, int start) {
        int indexofSingleQuote = expressionString.indexOf(39, start);
        int indexofDoubleQuote = expressionString.indexOf(34, start);
        return StringUtils.minIndex(indexofSingleQuote, indexofDoubleQuote);
    }

    private static int indexOfMatchingClosingBrace(String expressionString, int indexofOpeningBrace) {
        int i;
        block3: {
            int len = expressionString.length();
            i = indexofOpeningBrace + 1;
            do {
                if (i >= len) {
                    throw new ReferenceSyntaxException("Missing closing brace. Expression: '" + expressionString + "'");
                }
                int indexofClosingBrace = expressionString.indexOf(125, i);
                if ((i = StringUtils.minIndex(indexofClosingBrace, ELParserHelper.findQuote(expressionString, i))) < 0) {
                    throw new ReferenceSyntaxException("Missing closing brace. Expression: '" + expressionString + "'");
                }
                if (i == indexofClosingBrace) break block3;
            } while ((i = ELParserHelper.indexOfMatchingClosingQuote(expressionString, i) + 1) != 0);
            throw new ReferenceSyntaxException("Missing closing quote. Expression: '" + expressionString + "'");
        }
        return i;
    }

    private static int indexOfMatchingClosingQuote(String expressionString, int indexOfOpeningQuote) {
        char quote = expressionString.charAt(indexOfOpeningQuote);
        int i = expressionString.indexOf(quote, indexOfOpeningQuote + 1);
        while (i >= 0) {
            if (!ELParserHelper.isEscaped(expressionString, i)) {
                return i;
            }
            i = expressionString.indexOf(quote, i + 1);
        }
        return -1;
    }

    private static boolean isEscaped(String expressionString, int i) {
        int escapeCharCount = 0;
        while (--i >= 0 && expressionString.charAt(i) == '\\') {
            ++escapeCharCount;
        }
        return escapeCharCount % 2 != 0;
    }

    private static void replaceSuffixes(Object expression) {
        if (expression instanceof Expression) {
            ELParserHelper.replaceSuffixes((Expression)expression);
        } else if (expression instanceof ExpressionString) {
            ELParserHelper.replaceSuffixes((ExpressionString)expression);
        } else {
            throw new IllegalStateException("Expression element of unknown class: " + expression.getClass().getName());
        }
    }

    private static void replaceSuffixes(ExpressionString expressionString) {
        Object[] expressions = expressionString.getElements();
        int len = expressions.length;
        for (int i = 0; i < len; ++i) {
            Object expression = expressions[i];
            if (expression instanceof Expression) {
                ELParserHelper.replaceSuffixes((Expression)expression);
                continue;
            }
            if (expression instanceof ExpressionString) {
                ELParserHelper.replaceSuffixes((ExpressionString)expression);
                continue;
            }
            if (expression instanceof String) continue;
            throw new IllegalStateException("Expression element of unknown class: " + expression.getClass().getName());
        }
    }

    static void replaceSuffixes(Expression expression) {
        if (expression instanceof BinaryOperatorExpression) {
            ELParserHelper.replaceSuffixes(((BinaryOperatorExpression)expression).getExpression());
        } else if (expression instanceof ComplexValue) {
            ELParserHelper.replaceSuffixes((ComplexValue)expression);
        } else if (expression instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            ELParserHelper.replaceSuffixes(conditionalExpression.getTrueBranch());
            ELParserHelper.replaceSuffixes(conditionalExpression.getFalseBranch());
        } else if (expression instanceof UnaryOperatorExpression) {
            ELParserHelper.replaceSuffixes(((UnaryOperatorExpression)expression).getExpression());
        } else if (!(expression instanceof FunctionInvocation || expression instanceof Literal || expression instanceof NamedValue)) {
            throw new IllegalStateException("Expression element of unknown class: " + expression.getClass().getName());
        }
    }

    private static void replaceSuffixes(ComplexValue complexValue) {
        Application application = FacesContext.getCurrentInstance().getApplication();
        List suffixes = complexValue.getSuffixes();
        int len = suffixes.size();
        for (int i = 0; i < len; ++i) {
            ValueSuffix suffix = (ValueSuffix)suffixes.get(i);
            if (suffix instanceof PropertySuffix) {
                if (suffix instanceof MyPropertySuffix) {
                    throw new IllegalStateException("Suffix is MyPropertySuffix and must not be");
                }
                suffixes.set(i, new MyPropertySuffix((PropertySuffix)suffix, application));
                continue;
            }
            if (suffix instanceof ArraySuffix) {
                if (suffix instanceof MyArraySuffix) {
                    throw new IllegalStateException("Suffix is MyArraySuffix and must not be");
                }
                suffixes.set(i, new MyArraySuffix((ArraySuffix)suffix, application));
                continue;
            }
            throw new IllegalStateException("Unknown suffix class: " + suffix.getClass().getName());
        }
    }

    private static Integer coerceToIntegerWrapper(Object base, Object index) throws EvaluationException, ELException {
        Integer integer = Coercions.coerceToInteger((Object)index, (Logger)LOGGER);
        if (integer != null) {
            return integer;
        }
        throw new ReferenceSyntaxException("Cannot convert index to int for base " + base.getClass().getName() + " and index " + index);
    }

    public static Integer toIndex(Object base, Object index) throws ELException, EvaluationException {
        if (base instanceof List || base.getClass().isArray()) {
            return ELParserHelper.coerceToIntegerWrapper(base, index);
        }
        if (base instanceof UIComponent) {
            try {
                return ELParserHelper.coerceToIntegerWrapper(base, index);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyPropertySuffix
    extends PropertySuffix {
        private Application _application;

        public MyPropertySuffix(PropertySuffix propertySuffix, Application application) {
            super(propertySuffix.getName());
            this._application = application;
        }

        public Object evaluate(Object base, VariableResolver variableResolver, FunctionMapper functions, Logger logger) throws ELException {
            if (base == null) {
                return null;
            }
            String indexVal = this.getName();
            if (indexVal == null) {
                return null;
            }
            Integer index = ELParserHelper.toIndex(base, indexVal);
            if (index == null) {
                return this._application.getPropertyResolver().getValue(base, indexVal);
            }
            return this._application.getPropertyResolver().getValue(base, index);
        }
    }

    public static class MyArraySuffix
    extends ArraySuffix {
        private Application _application;

        public MyArraySuffix(ArraySuffix arraySuffix, Application application) {
            super(arraySuffix.getIndex());
            ELParserHelper.replaceSuffixes(this.getIndex());
            this._application = application;
        }

        public Object evaluate(Object base, VariableResolver variableResolver, FunctionMapper functions, Logger logger) throws ELException {
            if (base == null) {
                return null;
            }
            Object indexVal = this.getIndex().evaluate(variableResolver, functions, logger);
            if (indexVal == null) {
                return null;
            }
            Integer index = ELParserHelper.toIndex(base, indexVal);
            if (index == null) {
                return this._application.getPropertyResolver().getValue(base, indexVal);
            }
            return this._application.getPropertyResolver().getValue(base, index);
        }
    }
}

