/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.remoting.axis.deployer;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.utils.XMLUtils;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.remoting.axis.DeployFailedException;
import org.seasar.remoting.axis.ServiceDef;
import org.seasar.remoting.axis.deployer.AxisDeployer;
import org.seasar.remoting.axis.deployer.ItemDeployer;
import org.seasar.remoting.axis.deployment.WSDDS2Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceDeployer
implements ItemDeployer {
    private static final Logger logger = Logger.getLogger((Class)(class$org$seasar$remoting$axis$deployer$ServiceDeployer == null ? (class$org$seasar$remoting$axis$deployer$ServiceDeployer = ServiceDeployer.class$("org.seasar.remoting.axis.deployer.ServiceDeployer")) : class$org$seasar$remoting$axis$deployer$ServiceDeployer));
    protected final AxisDeployer deployer;
    static /* synthetic */ Class class$org$seasar$remoting$axis$deployer$ServiceDeployer;

    public ServiceDeployer(AxisDeployer deployer) {
        this.deployer = deployer;
    }

    public void deploy(ComponentDef componentDef, MetaDef metaDef) {
        WSDDS2Service service = this.createWSDDS2Service(componentDef, metaDef);
        this.deployer.getDeployment(componentDef.getContainer()).deployService((WSDDService)service);
        if (logger.isDebugEnabled()) {
            logger.log("DAXS0003", new Object[]{service.getQName()});
        }
    }

    protected WSDDS2Service createWSDDS2Service(ComponentDef componentDef, MetaDef metaDef) {
        try {
            Object metadata = metaDef.getValue();
            if (metadata == null) {
                return new WSDDS2Service(componentDef);
            }
            if (metadata instanceof ServiceDef) {
                return new WSDDS2Service(componentDef, (ServiceDef)metadata);
            }
            if (metadata instanceof String) {
                return new WSDDS2Service(componentDef, this.getServiceElement((String)metadata));
            }
            throw new DeployFailedException();
        }
        catch (WSDDException e) {
            throw new DeployFailedException(e);
        }
    }

    protected Element getServiceElement(String wsddFileName) {
        try {
            InputStream is = ResourceUtil.getResourceAsStream((String)wsddFileName);
            Element documentElement = XMLUtils.newDocument((InputStream)is).getDocumentElement();
            Element[] serviceElements = this.getChildElements(documentElement, "service");
            if (serviceElements.length != 1) {
                throw new DeployFailedException(MessageFormatter.getSimpleMessage((String)"EAXS0005", (Object[])new Object[]{wsddFileName}));
            }
            return serviceElements[0];
        }
        catch (DeployFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeployFailedException(e);
        }
    }

    protected Element[] getChildElements(Element parent, String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element element;
            Node thisNode = children.item(i);
            if (!(thisNode instanceof Element) || !(element = (Element)thisNode).getLocalName().equals(name)) continue;
            result.add(element);
        }
        return result.toArray(new Element[result.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

