/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.DataSourceUtil;

public class BasicHandler {
    private DataSource dataSource_;
    private String sql_;
    private StatementFactory statementFactory_ = BasicStatementFactory.INSTANCE;

    public BasicHandler() {
    }

    public BasicHandler(DataSource ds, String sql) {
        this(ds, sql, BasicStatementFactory.INSTANCE);
    }

    public BasicHandler(DataSource ds, String sql, StatementFactory statementFactory) {
        this.setDataSource(ds);
        this.setSql(sql);
        this.setStatementFactory(statementFactory);
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource_ = dataSource;
    }

    public String getSql() {
        return this.sql_;
    }

    public void setSql(String sql) {
        this.sql_ = sql;
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory_;
    }

    public void setStatementFactory(StatementFactory statementFactory) {
        this.statementFactory_ = statementFactory;
    }

    protected Connection getConnection() {
        if (this.dataSource_ == null) {
            throw new EmptyRuntimeException("dataSource");
        }
        return DataSourceUtil.getConnection((DataSource)this.dataSource_);
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        if (this.sql_ == null) {
            throw new EmptyRuntimeException("sql");
        }
        return this.statementFactory_.createPreparedStatement(connection, this.sql_);
    }

    protected void bindArgs(PreparedStatement ps, Object[] args, Class[] argTypes) {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            ValueType valueType = ValueTypes.getValueType(argTypes[i]);
            try {
                valueType.bindValue(ps, i + 1, args[i]);
            }
            catch (SQLException ex) {
                throw new SQLRuntimeException(ex);
            }
            ++i;
        }
    }

    protected Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argTypes = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            Object arg = args[i];
            if (arg != null) {
                argTypes[i] = arg.getClass();
            }
            ++i;
        }
        return argTypes;
    }

    protected String getCompleteSql(Object[] args) {
        if (args == null || args.length == 0) {
            return this.sql_;
        }
        StringBuffer buf = new StringBuffer(200);
        int pos = 0;
        int pos2 = 0;
        int index = 0;
        while ((pos = this.sql_.indexOf(63, pos2)) > 0) {
            buf.append(this.sql_.substring(pos2, pos));
            buf.append(this.getBindVariableText(args[index++]));
            pos2 = pos + 1;
        }
        buf.append(this.sql_.substring(pos2));
        return buf.toString();
    }

    protected String getBindVariableText(Object bindVariable) {
        if (bindVariable instanceof String) {
            return "'" + bindVariable + "'";
        }
        if (bindVariable instanceof Number) {
            return bindVariable.toString();
        }
        if (bindVariable instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            return "'" + sdf.format((Date)bindVariable) + "'";
        }
        if (bindVariable instanceof Boolean) {
            return bindVariable.toString();
        }
        if (bindVariable == null) {
            return "null";
        }
        return "'" + bindVariable.toString() + "'";
    }
}

