/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.xml;

import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.xml.TagHandler;
import org.seasar.framework.xml.TagHandlerContext;
import org.seasar.framework.xml.TagHandlerRule;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class SaxHandler
extends DefaultHandler {
    private TagHandlerRule tagHandlerRule_;
    private TagHandlerContext context_ = new TagHandlerContext();
    private Map dtdPaths_ = new HashMap();

    public SaxHandler(TagHandlerRule tagHandlerRule) {
        this.tagHandlerRule_ = tagHandlerRule;
    }

    public TagHandlerContext getTagHandlerContext() {
        return this.context_;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        this.appendBody();
        this.context_.startElement(qName);
        this.start(attributes);
    }

    public void characters(char[] buffer, int start, int length) {
        int begin = start;
        int end = start + length;
        int i = begin;
        while (i < end) {
            if (buffer[i] == '\n') {
                this.context_.characters(buffer, begin, i - begin + 1);
                this.appendBody();
                begin = i + 1;
            }
            ++i;
        }
        if (begin < end) {
            this.context_.characters(buffer, begin, end - begin);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.appendBody();
        this.end();
        this.context_.endElement();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        String dtdPath = null;
        if (publicId != null) {
            dtdPath = (String)this.dtdPaths_.get(publicId);
        }
        if (dtdPath == null) {
            return null;
        }
        return new InputSource(ResourceUtil.getResourceAsStream(dtdPath));
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e);
    }

    public void registerDtdPath(String publicId, String dtdPath) {
        this.dtdPaths_.put(publicId, dtdPath);
    }

    public Object getResult() {
        return this.context_.getResult();
    }

    private TagHandler getTagHandlerByPath() {
        return this.tagHandlerRule_.getTagHandler(this.context_.getPath());
    }

    private TagHandler getTagHandlerByQName() {
        return this.tagHandlerRule_.getTagHandler(this.context_.getQName());
    }

    private void start(Attributes attributes) {
        TagHandler th = this.getTagHandlerByPath();
        this.start(th, attributes);
        th = this.getTagHandlerByQName();
        this.start(th, attributes);
    }

    private void start(TagHandler handler, Attributes attributes) {
        if (handler != null) {
            try {
                handler.start(this.context_, attributes);
            }
            catch (RuntimeException ex) {
                this.reportDetailPath();
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    private void appendBody() {
        String characters = this.context_.getCharacters();
        if (characters.length() > 0) {
            TagHandler th = this.getTagHandlerByPath();
            this.appendBody(th, characters);
            th = this.getTagHandlerByQName();
            this.appendBody(th, characters);
            this.context_.clearCharacters();
        }
    }

    private void appendBody(TagHandler handler, String characters) {
        if (handler != null) {
            try {
                handler.appendBody(this.context_, characters);
            }
            catch (RuntimeException ex) {
                this.reportDetailPath();
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    private void end() {
        String body = this.context_.getBody();
        TagHandler th = this.getTagHandlerByPath();
        this.end(th, body);
        th = this.getTagHandlerByQName();
        this.end(th, body);
    }

    private void end(TagHandler handler, String body) {
        if (handler != null) {
            try {
                handler.end(this.context_, body);
            }
            catch (RuntimeException ex) {
                this.reportDetailPath();
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    private void reportDetailPath() {
        System.err.println("Exception occured at " + this.context_.getDetailPath());
    }
}

