/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ConstantAttribute;

public final class FieldInfo {
    ConstPool constPool;
    int accessFlags;
    int name;
    int descriptor;
    LinkedList attribute;

    private FieldInfo(ConstPool cp) {
        this.constPool = cp;
        this.accessFlags = 0;
        this.attribute = null;
    }

    public FieldInfo(ConstPool cp, String fieldName, String desc) {
        this(cp);
        this.name = cp.addUtf8Info(fieldName);
        this.descriptor = cp.addUtf8Info(desc);
    }

    FieldInfo(ConstPool cp, DataInputStream in) throws IOException {
        this(cp);
        this.read(in);
    }

    void compact(ConstPool cp) {
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.attribute = AttributeInfo.copyAll(this.attribute, cp);
        this.constPool = cp;
    }

    void prune(ConstPool cp) {
        int index = this.getConstantValue();
        if (index == 0) {
            this.attribute = null;
        } else {
            index = this.constPool.copy(index, cp, null);
            this.attribute = new LinkedList();
            this.attribute.add(new ConstantAttribute(cp, index));
        }
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.constPool = cp;
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public void setName(String newName) {
        this.name = this.constPool.addUtf8Info(newName);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int acc) {
        this.accessFlags = acc;
    }

    public String getDescriptor() {
        return this.constPool.getUtf8Info(this.descriptor);
    }

    public void setDescriptor(String desc) {
        if (!desc.equals(this.getDescriptor())) {
            this.descriptor = this.constPool.addUtf8Info(desc);
        }
    }

    public int getConstantValue() {
        if ((this.accessFlags & 8) == 0) {
            return 0;
        }
        ConstantAttribute attr = (ConstantAttribute)this.getAttribute("ConstantValue");
        if (attr == null) {
            return 0;
        }
        return attr.getConstantValue();
    }

    public List getAttributes() {
        if (this.attribute == null) {
            this.attribute = new LinkedList();
        }
        return this.attribute;
    }

    public AttributeInfo getAttribute(String name) {
        return AttributeInfo.lookup(this.attribute, name);
    }

    public void addAttribute(AttributeInfo info) {
        if (this.attribute == null) {
            this.attribute = new LinkedList();
        }
        AttributeInfo.remove(this.attribute, info.getName());
        this.attribute.add(info);
    }

    private void read(DataInputStream in) throws IOException {
        this.accessFlags = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.descriptor = in.readUnsignedShort();
        int n = in.readUnsignedShort();
        this.attribute = new LinkedList();
        for (int i = 0; i < n; ++i) {
            this.attribute.add(AttributeInfo.read(this.constPool, in));
        }
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.accessFlags);
        out.writeShort(this.name);
        out.writeShort(this.descriptor);
        if (this.attribute == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.attribute.size());
            AttributeInfo.writeAll(this.attribute, out);
        }
    }
}

