package org.seasar.framework.container;

import org.seasar.framework.exception.SRuntimeException;

/**
 * @author higa
 *
 * `ꂽR|[lg̃NXƎۂ̃R|[lg̃NX
 * قȂƂ̎sO
 */
public class ClassUnmatchRuntimeException extends SRuntimeException {

	private Class componentClass_;
	private Class realComponentClass_;
	
	/**
	 * @param componentKey
	 */
	public ClassUnmatchRuntimeException(
		Class componentClass,
		Class realComponentClass) {
		super("ESSR0069", new Object[] { componentClass.getName(),
			realComponentClass != null ? realComponentClass.getName() : "null"});
		componentClass_ = componentClass;
		realComponentClass_ = realComponentClass;
	}
	
	public Class getComponentClass() {
		return componentClass_;
	}
	
	public Class getRealComponentClass() {
		return realComponentClass_;
	}
}