/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.seasar.framework.log.Logger;
import org.seasar.jsf.exception.NoValueHolderRuntimeException;
import org.seasar.jsf.exception.SubmittedValueNotStringRuntimeException;

public final class RenderUtil {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.util.RenderUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    private RenderUtil() {
    }

    public static void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            RenderUtil.encodeChild(context, (UIComponent)i.next());
            if (context.getResponseComplete()) break;
        }
    }

    public static void encodeChild(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            RenderUtil.encodeChildren(context, component);
        }
        component.encodeEnd(context);
    }

    public static String getValueByString(FacesContext context, UIComponent component) {
        EditableValueHolder evh;
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new NoValueHolderRuntimeException(component.getClass());
        }
        if (component instanceof EditableValueHolder && (submittedValue = (evh = (EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof String) {
                return (String)submittedValue;
            }
            throw new SubmittedValueNotStringRuntimeException();
        }
        ValueHolder vh = (ValueHolder)component;
        Object value = vh.getValue();
        Converter converter = vh.getConverter();
        if (converter == null && value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            try {
                converter = context.getApplication().createConverter(value.getClass());
            }
            catch (FacesException ex) {
                logger.log((Throwable)ex);
            }
        }
        if (converter == null) {
            if (value == null) {
                return "";
            }
            return value.toString();
        }
        return converter.getAsString(context, component, value);
    }

    public static boolean renderAttributes(ResponseWriter writer, UIComponent component, String[] attributeNames) throws IOException {
        boolean somethingDone = false;
        int i = 0;
        int len = attributeNames.length;
        while (i < len) {
            String attrName = attributeNames[i];
            if (RenderUtil.renderAttribute(writer, component, attrName)) {
                somethingDone = true;
            }
            ++i;
        }
        return somethingDone;
    }

    public static boolean renderAttribute(ResponseWriter writer, UIComponent component, String attributeName) throws IOException {
        Object value = component.getAttributes().get(attributeName);
        return RenderUtil.renderAttribute(writer, attributeName, value, attributeName);
    }

    public static boolean renderAttribute(ResponseWriter writer, String attributeName, Object value, String propertyName) throws IOException {
        if (value == null) {
            return false;
        }
        if (attributeName.equalsIgnoreCase("styleClass")) {
            attributeName = "class";
        }
        writer.writeAttribute(attributeName, value, propertyName);
        return true;
    }
}

