package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.TagProcessorImpl;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class FormSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "form";
	
	public FormSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		return JsfConstants.FORM_ELEM.equalsIgnoreCase(qName);
	}

	public TagProcessor createProcessor() {
		return new TagProcessorImpl(getInject());
	}
	
	public String getInject() {
		return getJsfHtmlInject(TAG_NAME);
	}
}