/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hibernate3.impl;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;
import org.seasar.hibernate3.S2SessionFactory;

public final class S2SessionFactoryImpl
implements S2SessionFactory,
Synchronization {
    private static final String DEFAULT_CONFIG_PATH = "hibernate.cfg.xml";
    private final TransactionManager transactionManager_;
    private final DataSource dataSource_;
    private String configPath_ = "hibernate.cfg.xml";
    private Interceptor interceptor_;
    private SessionFactory sessionFactory_;
    private final Map txSessions_ = Collections.synchronizedMap(new HashMap());

    public S2SessionFactoryImpl(TransactionManager transactionManager, DataSource dataSource) {
        this.transactionManager_ = transactionManager;
        this.dataSource_ = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public String getConfigPath() {
        return this.configPath_;
    }

    public void setConfigPath(String configPath) {
        this.configPath_ = configPath;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor_ = interceptor;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory_ != null) {
            return this.sessionFactory_;
        }
        Configuration cfg = new Configuration();
        cfg.configure(ResourceUtil.getResource((String)this.configPath_));
        if (this.interceptor_ != null) {
            cfg.setInterceptor(this.interceptor_);
        }
        this.sessionFactory_ = cfg.buildSessionFactory();
        return this.sessionFactory_;
    }

    public int getTxSessionSize() {
        return this.txSessions_.size();
    }

    public Session getSession() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return this.createSession();
        }
        Session session = (Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        return this.bindSession(tx);
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.getTransactionManager());
    }

    private Session createSession() {
        return this.getSessionFactory().openSession(this.getConnection());
    }

    private Connection getConnection() {
        return DataSourceUtil.getConnection((DataSource)this.getDataSource());
    }

    private Session bindSession(Transaction tx) {
        Session session = (Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        session = this.createSession();
        this.txSessions_.put(tx, session);
        TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)this);
        return session;
    }

    public void beforeCompletion() {
        this.flushSession();
    }

    public void afterCompletion(int status) {
        this.closeSession();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeSession() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return;
        }
        Session session = (Session)this.txSessions_.remove(tx);
        if (session == null) return;
        if (!session.isOpen()) {
            return;
        }
        try {
            session.clear();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ConnectionUtil.close((Connection)session.close());
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        ConnectionUtil.close((Connection)session.close());
    }

    private void flushSession() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return;
        }
        Session session = (Session)this.txSessions_.get(tx);
        if (session == null || !session.isOpen() || session.getFlushMode().equals(FlushMode.NEVER)) {
            return;
        }
        session.flush();
    }
}

