package org.seasar.hibernate3.dao.criteria;

import org.hibernate.Criteria;
import org.hibernate.criterion.Expression;

/**
 * @author kenichi_okazaki
 */
public class LtCriteriaCommand extends abstractCriteriaCommand {

    /**
     * @param fieldName
     * @param dtoFieldName
     */
    public LtCriteriaCommand(String fieldName, String dtoFieldName) {
        super(fieldName, dtoFieldName);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.seasar.hibernate.dao.criteria.CriteriaCommand#getCriteria(net.sf.hibernate.Criteria,
     *      java.lang.Object)
     */
    public Criteria getCriteria(Criteria criteria, Object value) {

        return criteria.add(Expression.lt(fieldName_, value));
    }
}
