package org.seasar.hibernate3.dao.impl;

import java.util.List;
import java.lang.reflect.Method;

import org.seasar.hibernate3.S2SessionFactory;

/**
 * @author kenichi_okazaki
 *
 */
public abstract class AbstractQueryHibernateCommand extends AbstractHibernateCommand {

	private Class beanClass_;
	private Method method_;
	private ArgsMetaData argsMeta_;
	
	/**
	 * @param s2sessionFactory
	 */
	public AbstractQueryHibernateCommand(S2SessionFactory s2sessionFactory,Class beanClass,Method method) {
		super(s2sessionFactory);
		beanClass_ = beanClass;
		method_ = method;
		

	}


	
	protected Object getReturnObject(Method method,List ret){
		if (method.getReturnType().isAssignableFrom(List.class)) {
			return ret;
		} else  {
			if(ret == null || ret.size() == 0){
				return null;
			} else {
				return ret.get(0);
			}
		}
	}


	
	public Method getMethod() {
		return method_;
	}

	public void setMethod(Method method) {
		method_ = method;
	}
	
	public Class getBeanClass() {
		return beanClass_;
	}

	public void setBeanClass(Class beanClass) {
		beanClass_ = beanClass;
	}
	
	public ArgsMetaData getArgsMeta() {
		return argsMeta_;
	}

	public void setArgsMeta(ArgsMetaData argsMeta) {
		argsMeta_ = argsMeta;
	}

}
