package org.seasar.hibernate3.dao.impl;

import java.lang.reflect.Method;

//import net.sf.hibernate.Criteria;
//import net.sf.hibernate.HibernateException;

import org.hibernate.Criteria;
import org.hibernate.Session;
import org.seasar.hibernate3.S2SessionFactory;
import org.seasar.hibernate3.dao.criteria.CriteriaCommand;

/**
 * @author kenichi_okazaki 
 */
public class AutoArgsQueryCommand extends AbstractAutoQueryCommand {

	public AutoArgsQueryCommand(S2SessionFactory s2sessionFactory,Class beanClass, Method method) {
		super(s2sessionFactory, beanClass,method);
	}


	protected Criteria getArgsCriteria(Session s2session, Object[] args)  {

		ArgsMetaData argsMeta = getArgsMeta();
		String[] argNames = argsMeta.getArgNames();
		
		Criteria criteria = s2session.createCriteria( getBeanClass() );
		for (int i = 0; i < argsMeta.getArgsCount(); i++) {
			Object value = argsMeta.getValue(args,i);
			if (value != null) {
				CriteriaCommand criteriaCommand = (CriteriaCommand)criteriaCommandList_.get(i);
				criteria = criteriaCommand.getCriteria( criteria, value ) ;
			}
		}
		return criteria;
	}





}