package org.seasar.hibernate3.dao.impl;

import java.lang.reflect.Method;
import java.util.List;

import org.hibernate.Query;

import org.seasar.hibernate3.S2SessionFactory;

/**
 * @author kenichi_okazaki
 *
 */
public class NamedQueryCommand extends AbstractHQLHibernateCommand  {


	private String namedQueryPath_;
	
	public NamedQueryCommand(S2SessionFactory s2sessionFactory,Class beanClass, Method method) {
		super(s2sessionFactory,beanClass,method);
	}

	/* (non-Javadoc)
	 * @see org.seasar.hibernate.dao.HibernateCommand#execute(org.seasar.hibernate.S2Session, java.lang.Object[])
	 */
	public Object execute( Object[] args) {
		Query query = getSession().getNamedQuery( namedQueryPath_);
		List ret = queryExecute( query, args );
		return getReturnObject(getMethod(),ret );
	}


	/**
	 * @param namedQueryPath_ The namedQueryPath_ to set.
	 */
	public void setNamedQueryPath(String namedQueryPath) {
		namedQueryPath_ = namedQueryPath;
	}
}
