/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CacheFree;
import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlException;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;

abstract class Cache {
    static final int CACHE_TYPE_DATA = 0;
    static final int CACHE_TYPE_TEXT = 1;
    static final int CACHE_TYPE_REVERSE_TEXT = 2;
    int currentAccessCount;
    int firstAccessCount;
    protected Database dDatabase;
    protected HsqlDatabaseProperties dbProps;
    protected String sName;
    protected boolean storeOnInsert;
    boolean cacheReadonly;
    boolean fileModified;
    int maxNioScale;
    int cacheScale;
    int cacheSizeScale;
    int cacheFileScale;
    protected int cachedRowPadding = 8;
    int cachedRowType = 0;
    protected int rowStoreExtra;
    int maxCacheSize;
    long maxCacheBytes;
    int multiplierMask;
    private CachedRowComparator rowComparator;
    private CachedRow[] rowTable;
    private CachedRow[] rData;
    private int[] accessCount;
    static final int FREE_POS_POS = 16;
    static final int INITIAL_FREE_POS = 32;
    static final int ROW_STORE_EXTRA_160 = 8;
    static final int ROW_STORE_EXTRA_170 = 4;
    protected ScaledRAFile rFile;
    protected int iFreePos;
    private CachedRow rFirst;
    CacheFree fRoot;
    int iFreeCount;
    int iCacheSize;
    long cacheBytesLength;
    RowInputInterface rowIn;
    protected RowOutputInterface rowOut;
    int makeRowCount = 0;
    int saveRowCount = 0;

    Cache(String string, Database database) throws HsqlException {
        this.sName = string;
        this.dDatabase = database;
        this.dbProps = database.getProperties();
        this.initParams();
        this.init();
    }

    protected void initParams() throws HsqlException {
        this.cacheScale = this.dbProps.getIntegerProperty("hsqldb.cache_scale", 14, 8, 18);
        this.cacheSizeScale = this.dbProps.getIntegerProperty("hsqldb.cache_size_scale", 10, 6, 20);
        this.cacheFileScale = this.dbProps.getIntegerProperty("hsqldb.cache_file_scale", 1, 1, 8);
        if (this.cacheFileScale != 8) {
            this.cacheFileScale = 1;
        }
        Trace.printSystemOut("cache_scale: " + this.cacheScale);
        Trace.printSystemOut("cache_size_scale: " + this.cacheSizeScale);
    }

    protected void init() {
        this.cacheReadonly = this.dDatabase.filesReadOnly;
        int n = 1 << this.cacheScale;
        int n2 = 1 << this.cacheSizeScale;
        this.maxCacheSize = n * 3;
        this.maxCacheBytes = this.maxCacheSize * n2;
        this.multiplierMask = n - 1;
        this.rowComparator = new CachedRowComparator();
        this.accessCount = new int[this.maxCacheSize];
        this.rowTable = new CachedRow[this.maxCacheSize];
        this.rData = new CachedRow[n];
        this.rFirst = null;
        this.iFreePos = 0;
        this.fRoot = null;
        this.iFreeCount = 0;
        this.iCacheSize = 0;
        this.cacheBytesLength = 0L;
    }

    protected void initBuffers() throws HsqlException {
        this.rowOut = RowOutputBase.newRowOutput(this.cachedRowType);
        this.rowIn = RowInputBase.newRowInput(this.cachedRowType);
        this.rowIn.setSystemId(true);
        this.rowStoreExtra = this.rowOut instanceof RowOutputBinary ? 4 : 8;
    }

    abstract void open(boolean var1) throws HsqlException;

    abstract void close() throws HsqlException;

    abstract void defrag() throws HsqlException;

    abstract void closeFile() throws HsqlException;

    abstract void free(CachedRow var1) throws HsqlException;

    protected abstract void setStorageSize(CachedRow var1) throws HsqlException;

    void add(CachedRow cachedRow) throws HsqlException {
        this.fileModified = true;
        if (this.iCacheSize >= this.maxCacheSize || (long)cachedRow.storageSize + this.cacheBytesLength > this.maxCacheBytes) {
            this.cleanUp();
        }
        this.setStorageSize(cachedRow);
        this.resetAccessCount();
        cachedRow.iLastAccess = this.currentAccessCount++;
        int n = this.setFilePos(cachedRow);
        int n2 = n >> 3 & this.multiplierMask;
        CachedRow cachedRow2 = this.rData[n2];
        if (cachedRow2 == null) {
            cachedRow2 = this.rFirst;
        }
        cachedRow.insert(cachedRow2);
        try {
            if (this.storeOnInsert) {
                this.saveRow(cachedRow);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29);
        }
        ++this.iCacheSize;
        this.cacheBytesLength += (long)cachedRow.storageSize;
        this.rData[n2] = cachedRow;
        this.rFirst = cachedRow;
    }

    abstract int setFilePos(CachedRow var1) throws HsqlException;

    protected abstract CachedRow makeRow(int var1, Table var2) throws HsqlException;

    CachedRow getRow(int n, Table table) throws HsqlException {
        CachedRow cachedRow = this.getRow(n);
        if (cachedRow != null) {
            this.resetAccessCount();
            cachedRow.iLastAccess = this.currentAccessCount++;
            return cachedRow;
        }
        if (this.iCacheSize >= this.maxCacheSize) {
            this.cleanUp();
        }
        if ((cachedRow = this.makeRow(n, table)) == null) {
            return cachedRow;
        }
        int n2 = cachedRow.iPos >> 3 & this.multiplierMask;
        CachedRow cachedRow2 = this.rData[n2];
        if (cachedRow2 == null) {
            cachedRow2 = this.rFirst;
        }
        cachedRow.insert(cachedRow2);
        ++this.iCacheSize;
        this.cacheBytesLength += (long)cachedRow.storageSize;
        this.rData[n2] = cachedRow;
        this.rFirst = cachedRow;
        this.resetAccessCount();
        cachedRow.iLastAccess = this.currentAccessCount++;
        if (this.cacheBytesLength > this.maxCacheBytes) {
            this.cleanUp();
        }
        return cachedRow;
    }

    private CachedRow getRow(int n) {
        CachedRow cachedRow;
        int n2 = n >> 3 & this.multiplierMask;
        CachedRow cachedRow2 = cachedRow = this.rData[n2];
        int n3 = 0;
        while (cachedRow != null) {
            n3 = cachedRow.iPos;
            if (n3 == n) {
                return cachedRow;
            }
            if ((n3 >> 3 & this.multiplierMask) == n2 && (cachedRow = cachedRow.rNext) != cachedRow2) continue;
            break;
        }
        return null;
    }

    private void cleanUp() throws HsqlException {
        int n;
        int n2;
        for (n2 = 0; n2 < this.iCacheSize; ++n2) {
            this.accessCount[n2] = this.rFirst.iLastAccess;
            this.rFirst = this.rFirst.rNext;
        }
        this.firstAccessCount = ArrayCounter.rank(this.accessCount, this.iCacheSize / 8, this.firstAccessCount, this.currentAccessCount, this.iCacheSize / 512) + 1;
        n2 = 0;
        for (n = 0; n < this.iCacheSize; ++n) {
            if (this.rFirst.iLastAccess < this.firstAccessCount) {
                this.rowTable[n2++] = this.rFirst;
            }
            this.rFirst = this.rFirst.rNext;
        }
        this.rowComparator.setType(this.rowComparator.COMPARE_POSITION);
        Sort.sort(this.rowTable, this.rowComparator, 0, n2 - 1);
        n = 0;
        for (int i = 0; i < n2; ++i) {
            CachedRow cachedRow = this.rowTable[i];
            try {
                if (cachedRow.hasChanged()) {
                    this.saveRow(cachedRow);
                    ++this.saveRowCount;
                }
                if (!cachedRow.isRoot()) {
                    this.remove(cachedRow);
                    ++n;
                }
            }
            catch (Exception exception) {
                throw Trace.error(29, 98, new Object[]{exception});
            }
            this.rowTable[i] = null;
        }
        this.initBuffers();
    }

    protected void remove(Table table) throws HsqlException {
        CachedRow cachedRow = this.rFirst;
        for (int i = 0; i < this.iCacheSize; ++i) {
            cachedRow = cachedRow.tTable == table ? this.remove(cachedRow) : cachedRow.rNext;
        }
    }

    protected CachedRow remove(CachedRow cachedRow) throws HsqlException {
        int n = cachedRow.iPos >> 3 & this.multiplierMask;
        if (this.rData[n] == cachedRow) {
            CachedRow cachedRow2;
            this.rFirst = cachedRow2 = cachedRow.rNext;
            if (cachedRow2 == cachedRow || (cachedRow2.iPos >> 3 & this.multiplierMask) != n) {
                cachedRow2 = null;
            }
            this.rData[n] = cachedRow2;
        }
        if (cachedRow == this.rFirst) {
            this.rFirst = this.rFirst.rNext;
            if (cachedRow == this.rFirst) {
                this.rFirst = null;
            }
        }
        --this.iCacheSize;
        this.cacheBytesLength -= (long)cachedRow.storageSize;
        return cachedRow.free();
    }

    private void resetAccessCount() throws HsqlException {
        if (this.currentAccessCount != Integer.MAX_VALUE) {
            return;
        }
        this.currentAccessCount >>= 2;
        this.firstAccessCount >>= 2;
        int n = this.iCacheSize;
        while (n-- > 0) {
            this.rFirst.iLastAccess >>= 2;
            this.rFirst = this.rFirst.rNext;
        }
    }

    protected void saveAll() throws HsqlException {
        int n;
        if (this.rFirst == null) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.iCacheSize; ++n) {
            if (this.rFirst.hasChanged) {
                this.rowTable[n2++] = this.rFirst;
            }
            this.rFirst = this.rFirst.rNext;
        }
        this.rowComparator.setType(this.rowComparator.COMPARE_POSITION);
        if (n2 != 0) {
            Sort.sort(this.rowTable, this.rowComparator, 0, n2 - 1);
        }
        for (n = 0; n < n2; ++n) {
            CachedRow cachedRow = this.rowTable[n];
            try {
                this.saveRow(cachedRow);
                ++this.saveRowCount;
                this.rowTable[n] = null;
                continue;
            }
            catch (Exception exception) {
                throw Trace.error(29, 99, new Object[]{exception});
            }
        }
    }

    protected abstract void saveRow(CachedRow var1) throws IOException, HsqlException;

    abstract void backup(String var1) throws HsqlException;

    int getFreePos() {
        return this.iFreePos;
    }

    class CachedRowComparator
    implements ObjectComparator {
        final int COMPARE_LAST_ACCESS = 0;
        final int COMPARE_POSITION = 1;
        final int COMPARE_SIZE = 2;
        private int compareType;

        CachedRowComparator() {
        }

        void setType(int n) {
            this.compareType = n;
        }

        public int compare(Object object, Object object2) {
            switch (this.compareType) {
                case 0: {
                    return ((CachedRow)object).iLastAccess - ((CachedRow)object2).iLastAccess;
                }
                case 1: {
                    return ((CachedRow)object).iPos - ((CachedRow)object2).iPos;
                }
                case 2: {
                    return ((CachedRow)object).storageSize - ((CachedRow)object2).storageSize;
                }
            }
            return 0;
        }
    }
}

