/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navigation;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.navigation.HtmlCommandNavigation;
import org.apache.myfaces.custom.navigation.HtmlPanelNavigation;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.ext.HtmlLinkRenderer;

public class HtmlNavigationRenderer
extends HtmlLinkRenderer {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$navigation$HtmlNavigationRenderer == null ? (class$org$apache$myfaces$custom$navigation$HtmlNavigationRenderer = HtmlNavigationRenderer.class$("org.apache.myfaces.custom.navigation.HtmlNavigationRenderer")) : class$org$apache$myfaces$custom$navigation$HtmlNavigationRenderer));
    private static final Integer ZERO_INTEGER = new Integer(0);
    static /* synthetic */ Class class$org$apache$myfaces$custom$navigation$HtmlNavigationRenderer;
    static /* synthetic */ Class class$org$apache$myfaces$custom$navigation$HtmlPanelNavigation;

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlCommandNavigation) {
            super.decode(facesContext, component);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandNavigation) {
            super.encodeBegin(facesContext, component);
        }
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandNavigation) {
            super.encodeChildren(facesContext, component);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof HtmlCommandNavigation) {
            super.encodeEnd(facesContext, component);
            return;
        }
        RendererUtils.checkParamValidity(facesContext, component, class$org$apache$myfaces$custom$navigation$HtmlPanelNavigation == null ? (class$org$apache$myfaces$custom$navigation$HtmlPanelNavigation = HtmlNavigationRenderer.class$("org.apache.myfaces.custom.navigation.HtmlPanelNavigation")) : class$org$apache$myfaces$custom$navigation$HtmlPanelNavigation);
        ResponseWriter writer = facesContext.getResponseWriter();
        HtmlPanelNavigation panelNav = (HtmlPanelNavigation)component;
        if (panelNav.getChildCount() > 0) {
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement("table", null);
            HtmlRendererUtils.renderHTMLAttributes(writer, panelNav, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
            if (panelNav.getStyle() == null && panelNav.getStyleClass() == null) {
                writer.writeAttribute("border", ZERO_INTEGER, null);
            }
            this.renderChildren(facesContext, writer, panelNav, panelNav.getChildren(), 0);
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.endElement("table");
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Navigation panel without children.");
        }
    }

    protected void renderChildren(FacesContext facesContext, ResponseWriter writer, HtmlPanelNavigation panelNav, List children, int level) throws IOException {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            String styleClass;
            String style;
            UIComponent child = (UIComponent)it.next();
            if (!child.isRendered()) continue;
            if (child instanceof HtmlCommandNavigation) {
                HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                style = this.getNavigationItemStyle(panelNav, (HtmlCommandNavigation)child);
                styleClass = this.getNavigationItemClass(panelNav, (HtmlCommandNavigation)child);
                writer.startElement("tr", null);
                writer.startElement("td", null);
                this.writeStyleAttributes(writer, style, styleClass);
                if (style != null || styleClass != null) {
                    writer.startElement("span", null);
                    this.writeStyleAttributes(writer, style, styleClass);
                }
                this.indent(writer, level);
                child.encodeBegin(facesContext);
                child.encodeEnd(facesContext);
                if (style != null || styleClass != null) {
                    writer.endElement("span");
                }
                writer.endElement("td");
                writer.endElement("tr");
                if (child.getChildCount() <= 0) continue;
                this.renderChildren(facesContext, writer, panelNav, child.getChildren(), level + 1);
                continue;
            }
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            style = panelNav.getSeparatorStyle();
            styleClass = panelNav.getSeparatorClass();
            writer.startElement("tr", null);
            writer.startElement("td", null);
            this.writeStyleAttributes(writer, style, styleClass);
            if (style != null || styleClass != null) {
                writer.startElement("span", null);
                this.writeStyleAttributes(writer, style, styleClass);
            }
            this.indent(writer, level);
            RendererUtils.renderChild(facesContext, child);
            if (style != null || styleClass != null) {
                writer.endElement("span");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    protected void indent(ResponseWriter writer, int level) throws IOException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buf.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        writer.write(buf.toString());
    }

    protected String getNavigationItemStyle(HtmlPanelNavigation navPanel, HtmlCommandNavigation navItem) {
        if (navItem.isActive()) {
            return navPanel.getActiveItemStyle();
        }
        if (navItem.isOpen()) {
            return navPanel.getOpenItemStyle();
        }
        return navPanel.getItemStyle();
    }

    protected String getNavigationItemClass(HtmlPanelNavigation navPanel, HtmlCommandNavigation navItem) {
        if (navItem.isActive()) {
            return navPanel.getActiveItemClass();
        }
        if (navItem.isOpen()) {
            return navPanel.getOpenItemClass();
        }
        return navPanel.getItemClass();
    }

    protected void writeStyleAttributes(ResponseWriter writer, String style, String styleClass) throws IOException {
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
    }

    protected String getStyle(FacesContext facesContext, UIComponent link) {
        UIComponent navPanel;
        if (!(link instanceof HtmlCommandNavigation)) {
            throw new IllegalArgumentException();
        }
        for (navPanel = link.getParent(); navPanel != null && !(navPanel instanceof HtmlPanelNavigation); navPanel = navPanel.getParent()) {
        }
        if (navPanel == null) {
            throw new IllegalStateException("HtmlCommandNavigation not nested in HtmlPanelNavigation!?");
        }
        HtmlCommandNavigation navItem = (HtmlCommandNavigation)link;
        if (navItem.isActive()) {
            return ((HtmlPanelNavigation)navPanel).getActiveItemStyle();
        }
        if (navItem.isOpen()) {
            return ((HtmlPanelNavigation)navPanel).getOpenItemStyle();
        }
        return ((HtmlPanelNavigation)navPanel).getItemStyle();
    }

    protected String getStyleClass(FacesContext facesContext, UIComponent link) {
        UIComponent navPanel;
        if (!(link instanceof HtmlCommandNavigation)) {
            throw new IllegalArgumentException();
        }
        for (navPanel = link.getParent(); navPanel != null && !(navPanel instanceof HtmlPanelNavigation); navPanel = navPanel.getParent()) {
        }
        if (navPanel == null) {
            throw new IllegalStateException("HtmlCommandNavigation not nested in HtmlPanelNavigation!?");
        }
        HtmlCommandNavigation navItem = (HtmlCommandNavigation)link;
        if (navItem.isActive()) {
            return ((HtmlPanelNavigation)navPanel).getActiveItemClass();
        }
        if (navItem.isOpen()) {
            return ((HtmlPanelNavigation)navPanel).getOpenItemClass();
        }
        return ((HtmlPanelNavigation)navPanel).getItemClass();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

