/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.util.LinkedHashSet;
import java.util.Set;
import org.seasar.framework.container.ExtensionNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AssemblerFactory;
import org.seasar.framework.container.deployer.ComponentDeployerFactory;
import org.seasar.framework.container.factory.AbstractS2ContainerBuilder;
import org.seasar.framework.container.factory.CircularIncludeRuntimeException;
import org.seasar.framework.container.factory.PathResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.container.factory.SimplePathResolver;
import org.seasar.framework.container.factory.XmlS2ContainerBuilder;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.util.ResourceUtil;

public final class S2ContainerFactory {
    public static final String FACTORY_CONFIG_KEY = "org.seasar.framework.container.factory.config";
    public static final String FACTORY_CONFIG_PATH = "s2container.dicon";
    public static final String DEFAULT_BUILDER_NAME = "defaultBuilder";
    protected static S2Container configurationContainer_;
    protected static Provider provider_;
    protected static S2ContainerBuilder defaultBuilder_;
    protected static ThreadLocal processingPaths_;
    static /* synthetic */ Class class$0;

    static {
        provider_ = new DefaultProvider();
        defaultBuilder_ = new XmlS2ContainerBuilder();
        processingPaths_ = new ThreadLocal(){

            protected Object initialValue() {
                return new LinkedHashSet();
            }
        };
        S2ContainerFactory.configure();
    }

    public static Provider getProvider() {
        return provider_;
    }

    public static void setProvider(Provider provider) {
        provider_ = provider;
    }

    public static S2ContainerBuilder getDefaultBuilder() {
        return defaultBuilder_;
    }

    public static void setDefaultBuilder(S2ContainerBuilder defaultBuilder) {
        defaultBuilder_ = defaultBuilder;
    }

    public static S2Container create(String path) {
        return S2ContainerFactory.getProvider().create(path);
    }

    public static S2Container create(String path, ClassLoader classLoader) {
        return S2ContainerFactory.getProvider().create(path, classLoader);
    }

    public static S2Container include(S2Container parent, String path) {
        return S2ContainerFactory.getProvider().include(parent, path);
    }

    protected static void configure() {
        String configFile = System.getProperty(FACTORY_CONFIG_KEY, FACTORY_CONFIG_PATH);
        if (ResourceUtil.isExist(configFile)) {
            Configurator configurator;
            XmlS2ContainerBuilder builder = new XmlS2ContainerBuilder();
            configurationContainer_ = builder.build(configFile);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.seasar.framework.container.factory.S2ContainerFactory$Configurator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (configurationContainer_.hasComponentDef(clazz)) {
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.seasar.framework.container.factory.S2ContainerFactory$Configurator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                configurator = (Configurator)configurationContainer_.getComponent(clazz2);
            } else {
                configurator = new DefaultConfigurator();
            }
            configurator.configure(configurationContainer_);
        }
    }

    protected static void enter(String path) {
        Set paths = (Set)processingPaths_.get();
        if (paths.contains(path)) {
            throw new CircularIncludeRuntimeException(path, paths);
        }
        paths.add(path);
    }

    protected static void leave(String path) {
        Set paths = (Set)processingPaths_.get();
        paths.remove(path);
    }

    public interface Provider {
        public S2Container create(String var1);

        public S2Container create(String var1, ClassLoader var2);

        public S2Container include(S2Container var1, String var2);
    }

    public static class DefaultProvider
    implements Provider {
        protected PathResolver pathResolver_ = new SimplePathResolver();

        public PathResolver getPathResolver() {
            return this.pathResolver_;
        }

        public void setPathResolver(PathResolver pathResolver) {
            this.pathResolver_ = pathResolver;
        }

        public S2Container create(String path) {
            S2Container s2Container;
            String realPath = this.pathResolver_.resolvePath(null, path);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container container;
                String ext = this.getExtension(realPath);
                s2Container = container = this.getBuilder(ext).build(realPath);
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                S2ContainerFactory.leave(realPath);
                throw throwable;
            }
            S2ContainerFactory.leave(realPath);
            return s2Container;
        }

        public S2Container create(String path, ClassLoader classLoader) {
            S2Container s2Container;
            String realPath = this.pathResolver_.resolvePath(null, path);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container container;
                String ext = this.getExtension(realPath);
                s2Container = container = this.getBuilder(ext).build(realPath, classLoader);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                S2ContainerFactory.leave(realPath);
                throw throwable;
            }
            S2ContainerFactory.leave(realPath);
            return s2Container;
        }

        public S2Container include(S2Container parent, String path) {
            S2Container s2Container;
            String realPath = this.pathResolver_.resolvePath(parent.getPath(), path);
            S2ContainerFactory.enter(realPath);
            try {
                S2Container root = parent.getRoot();
                S2Container child = null;
                S2Container s2Container2 = root;
                synchronized (s2Container2) {
                    if (root.hasDescendant(realPath)) {
                        child = root.getDescendant(realPath);
                        parent.include(child);
                    } else {
                        String ext = this.getExtension(realPath);
                        S2ContainerBuilder builder = this.getBuilder(ext);
                        child = builder.include(parent, realPath);
                        root.registerDescendant(child);
                    }
                }
                s2Container = child;
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                S2ContainerFactory.leave(realPath);
                throw throwable;
            }
            S2ContainerFactory.leave(realPath);
            return s2Container;
        }

        protected String getExtension(String path) {
            String ext = ResourceUtil.getExtension(path);
            if (ext == null) {
                throw new ExtensionNotFoundRuntimeException(path);
            }
            return ext;
        }

        protected S2ContainerBuilder getBuilder(String ext) {
            if (configurationContainer_ != null && configurationContainer_.hasComponentDef(ext)) {
                return (S2ContainerBuilder)configurationContainer_.getComponent(ext);
            }
            return defaultBuilder_;
        }
    }

    public interface Configurator {
        public void configure(S2Container var1);
    }

    public static class DefaultConfigurator
    implements Configurator {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;

        public void configure(S2Container bootstrapContainer) {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.seasar.framework.container.factory.S2ContainerFactory$Provider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (configurationContainer_.hasComponentDef(clazz4)) {
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$0 = Class.forName("org.seasar.framework.container.factory.S2ContainerFactory$Provider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                provider_ = (Provider)configurationContainer_.getComponent(clazz5);
            } else {
                Class<?> clazz6 = class$1;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$1 = Class.forName("org.seasar.framework.container.factory.PathResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (configurationContainer_.hasComponentDef(clazz6) && provider_ instanceof DefaultProvider) {
                    DefaultProvider defaultProvider = (DefaultProvider)provider_;
                    Class<?> clazz7 = class$1;
                    if (clazz7 == null) {
                        try {
                            clazz7 = class$1 = Class.forName("org.seasar.framework.container.factory.PathResolver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    defaultProvider.setPathResolver((PathResolver)configurationContainer_.getComponent(clazz7));
                }
            }
            if (configurationContainer_.hasComponentDef(S2ContainerFactory.DEFAULT_BUILDER_NAME)) {
                defaultBuilder_ = (S2ContainerBuilder)configurationContainer_.getComponent(S2ContainerFactory.DEFAULT_BUILDER_NAME);
            } else {
                Class<?> clazz8 = class$2;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$2 = Class.forName("org.seasar.framework.container.factory.ResourceResolver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (configurationContainer_.hasComponentDef(clazz8) && defaultBuilder_ instanceof AbstractS2ContainerBuilder) {
                    AbstractS2ContainerBuilder abstractS2ContainerBuilder = (AbstractS2ContainerBuilder)defaultBuilder_;
                    Class<?> clazz9 = class$2;
                    if (clazz9 == null) {
                        try {
                            clazz9 = class$2 = Class.forName("org.seasar.framework.container.factory.ResourceResolver");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    abstractS2ContainerBuilder.setResourceResolver((ResourceResolver)configurationContainer_.getComponent(clazz9));
                }
            }
            if ((clazz3 = class$3) == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.seasar.framework.container.impl.S2ContainerBehavior$Provider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (configurationContainer_.hasComponentDef(clazz3)) {
                Class<?> clazz10 = class$3;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$3 = Class.forName("org.seasar.framework.container.impl.S2ContainerBehavior$Provider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)configurationContainer_.getComponent(clazz10));
            }
            if ((clazz2 = class$4) == null) {
                try {
                    clazz2 = class$4 = Class.forName("org.seasar.framework.container.deployer.ComponentDeployerFactory$Provider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (configurationContainer_.hasComponentDef(clazz2)) {
                Class<?> clazz11 = class$4;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$4 = Class.forName("org.seasar.framework.container.deployer.ComponentDeployerFactory$Provider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ComponentDeployerFactory.setProvider((ComponentDeployerFactory.Provider)configurationContainer_.getComponent(clazz11));
            }
            if ((clazz = class$5) == null) {
                try {
                    clazz = class$5 = Class.forName("org.seasar.framework.container.assembler.AssemblerFactory$Provider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (configurationContainer_.hasComponentDef(clazz)) {
                Class<?> clazz12 = class$5;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$5 = Class.forName("org.seasar.framework.container.assembler.AssemblerFactory$Provider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                AssemblerFactory.setProvider((AssemblerFactory.Provider)configurationContainer_.getComponent(clazz12));
            }
        }
    }
}

