package org.seasar.struts.examples.employee.entity;

import java.io.Serializable;

import org.seasar.struts.examples.util.DateUtil;
import org.seasar.struts.examples.util.StringUtil;


public class Employee implements Serializable {

    public static final String TABLE = "EMP";

    private String empno = "";

    private String ename = "";

    private String job = "";

    private String mgr = "";

    private String hiredateDisplay = "";

    private String sal = "";

    private String comm = "";

    private String deptno = "";

    private int versionNo;

    public Employee() {
    }

    public String getEmpno() {
        return this.empno;
    }

    /**
     * @org.seasar.struts.validator.Required
     * @org.seasar.struts.validator.Integer
     * @org.seasar.struts.validator.Args(keys="form.employee.no")
     */
    public void setEmpno(String empno) {
        this.empno = empno;
    }

    public java.lang.String getEname() {
        return this.ename;
    }

    /**
     * @org.seasar.struts.validator.Required
     * @org.seasar.struts.validator.Args(keys="form.employee.name")
     */
    public void setEname(java.lang.String ename) {
        this.ename = ename;
    }

    public java.lang.String getJob() {
        return this.job;
    }

    public void setJob(java.lang.String job) {
        this.job = job;
    }

    public String getMgr() {
        return StringUtil.toNumericString(this.mgr);
    }

    /**
     * @org.seasar.struts.validator.Integer
     * @org.seasar.struts.validator.Args(keys="form.employee.manager")
     */
    public void setMgr(String mgr) {
        this.mgr = mgr;
    }

    public java.util.Date getHiredate() {
        return DateUtil.toDate(this.hiredateDisplay);
    }

    public void setHiredate(java.util.Date hiredate) {
        this.hiredateDisplay = StringUtil.toString(hiredate);
    }

    public String getHiredateDisplay() {
        return hiredateDisplay;
    }

    /**
     * @org.seasar.struts.validator.Date
     * @org.seasar.struts.validator.Args(keys="form.employee.hiredate")
     */
    public void setHiredateDisplay(String hiredateDisplay) {
        this.hiredateDisplay = hiredateDisplay;
    }

    public String getSal() {
        return StringUtil.toNumericString(this.sal);
    }

    /**
     * @org.seasar.struts.validator.Integer
     * @org.seasar.struts.validator.Args(keys="form.employee.salary")
     */
    public void setSal(String sal) {
        this.sal = sal;
    }

    public String getComm() {
        return StringUtil.toNumericString(this.comm);
    }

    /**
     * @org.seasar.struts.validator.Integer
     * @org.seasar.struts.validator.Args(keys="form.employee.commission")
     */
    public void setComm(String comm) {
        this.comm = comm;
    }

    public String getDeptno() {
        return StringUtil.toNumericString(this.deptno);
    }

    /**
     * @org.seasar.struts.validator.Required
     * @org.seasar.struts.validator.Args(keys="form.department")
     */
    public void setDeptno(String deptno) {
        this.deptno = deptno;
    }

    public int getVersionNo() {
        return versionNo;
    }

    public void setVersionNo(int versionNo) {
        this.versionNo = versionNo;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Employee)) {
            return false;
        }
        Employee castOther = (Employee) other;
        return getEmpno() == castOther.getEmpno();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[");
        setupToString(buf);
        buf.append("]");
        return buf.toString();
    }

    protected void setupToString(StringBuffer buf) {
        buf.append(empno).append(", ");
        buf.append(ename).append(", ");
        buf.append(job).append(", ");
        buf.append(mgr).append(", ");
        buf.append(hiredateDisplay).append(", ");
        buf.append(sal).append(", ");
        buf.append(comm).append(", ");
        buf.append(deptno).append(", ");
        buf.append(versionNo);
    }

    public int hashCode() {
        if (empno != null) {
            return Integer.parseInt(empno);
        } else {
            return 0;
        }
    }
}