/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.lifecycle;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.ViewTemplate;
import org.seasar.jsf.ViewTemplateFactory;
import org.seasar.jsf.component.S2UIViewRoot;
import org.seasar.jsf.processor.ViewProcessor;
import org.seasar.jsf.util.ExternalContextUtil;

public class LifecycleImpl
extends Lifecycle {
    private static final String VIEW_ID_ATTR = String.valueOf(LifecycleImpl.class.getName()) + ".VIEW_ID";
    private static final String EXECUTED_ATTR = String.valueOf(LifecycleImpl.class.getName()) + ".EXECUTED";
    private static final String REDIRECTED_TIME_ATTR = String.valueOf(LifecycleImpl.class.getName()) + ".REDIRECTED_TIME";
    private static final long REDIRECT_WAIT_TIME = 2000L;
    private PhaseListener[] phaseListeners = new PhaseListener[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void execute(FacesContext context) throws FacesException {
        try {
            Map requestMap;
            this.setupParams(context);
            boolean postback = this.restoreView(context);
            if (this.isFinished(context)) {
                return;
            }
            ExternalContext extContext = context.getExternalContext();
            Map sessionMap = extContext.getSessionMap();
            Long redirectedTime = (Long)sessionMap.get(REDIRECTED_TIME_ATTR);
            if (redirectedTime != null) {
                sessionMap.remove(REDIRECTED_TIME_ATTR);
                if (System.currentTimeMillis() - redirectedTime < 2000L) {
                    context.renderResponse();
                    return;
                }
            }
            if ((requestMap = extContext.getRequestMap()).containsKey(EXECUTED_ATTR)) {
                context.renderResponse();
                return;
            }
            requestMap.put(EXECUTED_ATTR, null);
            this.applyRequestValues(context);
            if (this.isFinished(context)) {
                return;
            }
            if (postback || this.hasEvent(context)) {
                this.processValidations(context);
                if (this.isFinished(context)) {
                    return;
                }
            }
            this.updateModelValues(context);
            if (this.isFinished(context)) {
                return;
            }
            this.invokeApplication(context);
            if (this.isGetRedirect(context)) {
                sessionMap.put(REDIRECTED_TIME_ATTR, new Long(System.currentTimeMillis()));
            }
        }
        catch (EvaluationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw ex;
        }
    }

    protected void setupParams(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String viewId = ExternalContextUtil.getViewId(externalContext);
        S2Container container = SingletonS2ContainerFactory.getContainer();
        HttpServletRequest request = container.getRequest();
        JsfConfig jsfConfig = (JsfConfig)container.getComponent(JsfConfig.class);
        ViewTemplateFactory viewTemplateFactory = (ViewTemplateFactory)container.getComponent(ViewTemplateFactory.class);
        ViewTemplate viewTemplate = viewTemplateFactory.getViewTemplate(viewId);
        ViewProcessor viewProcessor = (ViewProcessor)viewTemplate.getRootTagProcessor();
        HashMap params = new HashMap();
        viewProcessor.setupParams(jsfConfig, params);
        for (String key : params.keySet()) {
            Object value = params.get(key);
            request.setAttribute(key, value);
        }
    }

    protected boolean restoreView(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.RESTORE_VIEW);
        ExternalContext externalContext = context.getExternalContext();
        String viewId = ExternalContextUtil.getViewId(externalContext);
        Application application = context.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        UIViewRoot viewRoot = viewHandler.restoreView(context, viewId);
        if (viewRoot == null) {
            viewRoot = viewHandler.createView(context, viewId);
        }
        String previousViewId = this.getViewIdFromSession(externalContext);
        context.setViewRoot(viewRoot);
        this.saveViewIdToSession(externalContext, viewId);
        this.initializeChildren(context, (UIComponent)viewRoot);
        if (externalContext.getRequestParameterMap().isEmpty()) {
            context.renderResponse();
        }
        this.afterPhase(context, PhaseId.RESTORE_VIEW);
        return viewId.equals(previousViewId);
    }

    protected void applyRequestValues(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.APPLY_REQUEST_VALUES);
        context.getViewRoot().processDecodes(context);
        this.afterPhase(context, PhaseId.APPLY_REQUEST_VALUES);
    }

    protected void processValidations(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.PROCESS_VALIDATIONS);
        context.getViewRoot().processValidators(context);
        this.afterPhase(context, PhaseId.PROCESS_VALIDATIONS);
    }

    protected void updateModelValues(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.UPDATE_MODEL_VALUES);
        context.getViewRoot().processUpdates(context);
        this.afterPhase(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    protected void invokeApplication(FacesContext context) throws FacesException {
        this.beforePhase(context, PhaseId.INVOKE_APPLICATION);
        context.getViewRoot().processApplication(context);
        this.afterPhase(context, PhaseId.INVOKE_APPLICATION);
    }

    protected boolean isGetRedirect(FacesContext context) {
        if (!context.getResponseComplete()) {
            return false;
        }
        ExternalContext extContext = context.getExternalContext();
        HttpServletRequest request = ExternalContextUtil.getRequest(extContext);
        return request.getMethod().equals("GET");
    }

    public void render(FacesContext context) throws FacesException {
        if (context.getResponseComplete()) {
            return;
        }
        this.beforePhase(context, PhaseId.RENDER_RESPONSE);
        Application application = context.getApplication();
        ViewHandler viewHandler = application.getViewHandler();
        try {
            viewHandler.renderView(context, context.getViewRoot());
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw ex;
        }
        this.afterPhase(context, PhaseId.RENDER_RESPONSE);
    }

    protected String getViewIdFromSession(ExternalContext externalContext) {
        return (String)externalContext.getSessionMap().get(VIEW_ID_ATTR);
    }

    protected void saveViewIdToSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().put(VIEW_ID_ATTR, viewId);
    }

    protected void initializeChildren(FacesContext context, UIComponent component) {
        Iterator i = component.getFacetsAndChildren();
        while (i.hasNext()) {
            UIComponent child = (UIComponent)i.next();
            if (child instanceof UIInput) {
                UIInput input = (UIInput)child;
                input.setValid(true);
                input.setSubmittedValue(null);
                input.setValue(null);
                input.setLocalValueSet(false);
            }
            this.initializeChildren(context, child);
        }
    }

    protected boolean isFinished(FacesContext context) throws FacesException {
        return context.getResponseComplete() || context.getRenderResponse();
    }

    public void addPhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.add((Object[])this.phaseListeners, (Object)listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        this.phaseListeners = (PhaseListener[])ArrayUtil.remove((Object[])this.phaseListeners, (Object)listener);
    }

    public PhaseListener[] getPhaseListeners() {
        return this.phaseListeners;
    }

    protected void beforePhase(FacesContext context, PhaseId phaseId) {
        int i = 0;
        while (i < this.phaseListeners.length) {
            PhaseListener listener = this.phaseListeners[i];
            if (this.isTargetListener(listener, phaseId)) {
                listener.beforePhase(new PhaseEvent(context, phaseId, (Lifecycle)this));
            }
            ++i;
        }
    }

    protected void afterPhase(FacesContext context, PhaseId phaseId) {
        int i = 0;
        while (i < this.phaseListeners.length) {
            PhaseListener listener = this.phaseListeners[i];
            if (this.isTargetListener(listener, phaseId)) {
                listener.afterPhase(new PhaseEvent(context, phaseId, (Lifecycle)this));
            }
            ++i;
        }
    }

    protected boolean isTargetListener(PhaseListener listener, PhaseId phaseId) {
        int listenerOrdinal = listener.getPhaseId().getOrdinal();
        return listenerOrdinal == PhaseId.ANY_PHASE.getOrdinal() || listenerOrdinal == phaseId.getOrdinal();
    }

    protected boolean hasEvent(FacesContext context) {
        S2UIViewRoot viewRoot = (S2UIViewRoot)context.getViewRoot();
        return viewRoot.getEventSize() > 0;
    }
}

