/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.faces.render.Renderer;
import org.seasar.jsf.util.UIValueUtil;

public class HtmlSelectRenderer
extends Renderer {
    protected void renderSelectOptions(FacesContext context, UIOutput component, List selectItemList, List lookupAsString) throws IOException {
        for (SelectItem selectItem : selectItemList) {
            this.renderSelectItem(context, component, selectItem, lookupAsString);
        }
    }

    protected void renderSelectItem(FacesContext context, UIOutput component, SelectItem selectItem, List lookupAsString) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = component.getConverter();
        if (selectItem instanceof SelectItemGroup) {
            writer.startElement("optgroup", null);
            writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
            SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
            this.renderSelectOptions(context, component, Arrays.asList(selectItems), lookupAsString);
            writer.endElement("optgroup");
        } else {
            Object itemValue = selectItem.getValue();
            String itemStrValue = UIValueUtil.getValueAsString(context, (UIComponent)component, itemValue, converter);
            writer.write("\t\t");
            writer.startElement("option", null);
            if (itemStrValue != null) {
                writer.writeAttribute("value", (Object)itemStrValue, null);
            }
            if (lookupAsString.contains(itemStrValue)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            if (selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.endElement("option");
        }
    }
}

