/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.validator;

import java.util.ArrayList;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class ValidatorChain
implements Validator,
StateHolder {
    private boolean bTransient = false;
    List validators = new ArrayList();

    public void add(Validator validator) {
        this.validators.add(validator);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value == null) {
            return;
        }
        boolean valid = true;
        for (Validator validator : this.validators) {
            try {
                validator.validate(context, component, value);
            }
            catch (ValidatorException e) {
                valid = false;
                FacesMessage facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                facesMessage.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(component.getClientId(context), facesMessage);
            }
        }
        if (!valid) {
            throw new ValidatorException(null);
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[this.validators.size() + 1];
        int i = 0;
        while (i < this.validators.size()) {
            Object validator = this.validators.get(i);
            values[i] = validator instanceof StateHolder ? ((StateHolder)validator).saveState(context) : null;
            ++i;
        }
        values[values.length - 1] = this.validators;
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.validators = (List)values[values.length - 1];
        int i = 0;
        while (i < this.validators.size()) {
            Object validator = this.validators.get(i);
            if (validator instanceof StateHolder) {
                ((StateHolder)validator).restoreState(context, values[i]);
            }
            ++i;
        }
    }

    public boolean isTransient() {
        return this.bTransient;
    }

    public void setTransient(boolean transientValue) {
        this.bTransient = transientValue;
    }
}

