/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.seasar.extension.dataset.DataColumn;
import org.seasar.extension.dataset.DataRow;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.dataset.TableReader;
import org.seasar.extension.dataset.impl.DataRowReloadResultSetHandler;
import org.seasar.extension.dataset.impl.DataTableImpl;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;

public class SqlReloadTableReader
implements TableReader {
    private DataSource dataSource_;
    private DataTable table_;
    private String sql_;
    private String[] primaryKeys_;

    public SqlReloadTableReader(DataSource dataSource, DataTable table) {
        this.dataSource_ = dataSource;
        this.table_ = table;
        Connection con = DataSourceUtil.getConnection((DataSource)dataSource);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData((Connection)con);
            this.table_.setupMetaData(dbMetaData);
        }
        finally {
            ConnectionUtil.close((Connection)con);
        }
        this.setup();
    }

    private void setup() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("SELECT ");
        StringBuffer whereBuf = new StringBuffer(100);
        whereBuf.append(" WHERE");
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        int i = 0;
        while (i < this.table_.getColumnSize()) {
            DataColumn column = this.table_.getColumn(i);
            buf.append(column.getColumnName());
            buf.append(", ");
            if (column.isPrimaryKey()) {
                whereBuf.append(" ");
                whereBuf.append(column.getColumnName());
                whereBuf.append(" = ? AND");
                primaryKeyList.add(column.getColumnName());
            }
            ++i;
        }
        buf.setLength(buf.length() - 2);
        whereBuf.setLength(whereBuf.length() - 4);
        buf.append(" FROM ");
        buf.append(this.table_.getTableName());
        buf.append(whereBuf);
        this.sql_ = buf.toString();
        this.primaryKeys_ = primaryKeyList.toArray(new String[primaryKeyList.size()]);
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public DataTable getTable() {
        return this.table_;
    }

    public DataTable read() {
        DataTableImpl newTable = new DataTableImpl(this.table_.getTableName());
        int i = 0;
        while (i < this.table_.getColumnSize()) {
            DataColumn column = this.table_.getColumn(i);
            newTable.addColumn(column.getColumnName(), column.getColumnType());
            ++i;
        }
        i = 0;
        while (i < this.table_.getRowSize()) {
            DataRow row = this.table_.getRow(i);
            DataRow newRow = newTable.addRow();
            this.reload(row, newRow);
            ++i;
        }
        return newTable;
    }

    protected void reload(DataRow row, DataRow newRow) {
        BasicSelectHandler selectHandler = new BasicSelectHandler(this.dataSource_, this.sql_, new DataRowReloadResultSetHandler(row, newRow));
        Object[] args = new Object[this.primaryKeys_.length];
        int i = 0;
        while (i < this.primaryKeys_.length) {
            args[i] = row.getValue(this.primaryKeys_[i]);
            ++i;
        }
        selectHandler.execute(args);
    }
}

