/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.BigDecimalType;
import org.seasar.extension.jdbc.types.BinaryType;
import org.seasar.extension.jdbc.types.BooleanType;
import org.seasar.extension.jdbc.types.DoubleType;
import org.seasar.extension.jdbc.types.FloatType;
import org.seasar.extension.jdbc.types.IntegerType;
import org.seasar.extension.jdbc.types.LongType;
import org.seasar.extension.jdbc.types.ObjectType;
import org.seasar.extension.jdbc.types.ShortType;
import org.seasar.extension.jdbc.types.SqlDateType;
import org.seasar.extension.jdbc.types.StringType;
import org.seasar.extension.jdbc.types.TimeType;
import org.seasar.extension.jdbc.types.TimestampType;

public final class ValueTypes {
    public static final ValueType STRING = new StringType();
    public static final ValueType SHORT = new ShortType();
    public static final ValueType INTEGER = new IntegerType();
    public static final ValueType LONG = new LongType();
    public static final ValueType FLOAT = new FloatType();
    public static final ValueType DOUBLE = new DoubleType();
    public static final ValueType BIGDECIMAL = new BigDecimalType();
    public static final ValueType TIME = new TimeType();
    public static final ValueType SQLDATE = new SqlDateType();
    public static final ValueType TIMESTAMP = new TimestampType();
    public static final ValueType BINARY = new BinaryType();
    public static final ValueType BOOLEAN = new BooleanType();
    public static final ValueType OBJECT = new ObjectType();
    private static final Class BYTE_ARRAY_CLASS = new byte[0].getClass();
    private static Map types_ = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz, STRING);
        ValueTypes.registerValueType(Short.TYPE, SHORT);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz2, SHORT);
        ValueTypes.registerValueType(Integer.TYPE, INTEGER);
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz3, INTEGER);
        ValueTypes.registerValueType(Long.TYPE, LONG);
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz4, LONG);
        ValueTypes.registerValueType(Float.TYPE, FLOAT);
        Class<?> clazz5 = class$8;
        if (clazz5 == null) {
            try {
                clazz5 = class$8 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz5, FLOAT);
        ValueTypes.registerValueType(Double.TYPE, DOUBLE);
        Class<?> clazz6 = class$10;
        if (clazz6 == null) {
            try {
                clazz6 = class$10 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz6, DOUBLE);
        Class<?> clazz7 = class$11;
        if (clazz7 == null) {
            try {
                clazz7 = class$11 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz7, BIGDECIMAL);
        Class<?> clazz8 = class$12;
        if (clazz8 == null) {
            try {
                clazz8 = class$12 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz8, SQLDATE);
        Class<?> clazz9 = class$13;
        if (clazz9 == null) {
            try {
                clazz9 = class$13 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz9, TIME);
        Class<?> clazz10 = class$14;
        if (clazz10 == null) {
            try {
                clazz10 = class$14 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz10, TIMESTAMP);
        Class<?> clazz11 = class$15;
        if (clazz11 == null) {
            try {
                clazz11 = class$15 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz11, TIMESTAMP);
        Class<?> clazz12 = class$16;
        if (clazz12 == null) {
            try {
                clazz12 = class$16 = Class.forName("java.util.Calendar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz12, TIMESTAMP);
        ValueTypes.registerValueType(BYTE_ARRAY_CLASS, BINARY);
        ValueTypes.registerValueType(Boolean.TYPE, BOOLEAN);
        Class<?> clazz13 = class$18;
        if (clazz13 == null) {
            try {
                clazz13 = class$18 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValueTypes.registerValueType(clazz13, BOOLEAN);
    }

    private ValueTypes() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerValueType(Class clazz, ValueType valueType) {
        Map map = types_;
        synchronized (map) {
            types_.put(clazz, valueType);
        }
    }

    public static ValueType getValueType(Object obj) {
        if (obj == null) {
            return OBJECT;
        }
        return ValueTypes.getValueType(obj.getClass());
    }

    public static ValueType getValueType(Class clazz) {
        if (clazz == null) {
            return OBJECT;
        }
        ValueType valueType = ValueTypes.getValueType0(clazz);
        if (valueType != null) {
            return valueType;
        }
        return OBJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ValueType getValueType0(Class clazz) {
        Map map = types_;
        synchronized (map) {
            return (ValueType)types_.get(clazz);
        }
    }

    public static ValueType getValueType(int type) {
        switch (type) {
            case -6: 
            case 5: {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 4: {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case -5: {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 6: 
            case 7: {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 8: {
                Class<?> clazz = class$10;
                if (clazz == null) {
                    try {
                        clazz = class$10 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 2: 
            case 3: {
                Class<?> clazz = class$11;
                if (clazz == null) {
                    try {
                        clazz = class$11 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 91: {
                Class<?> clazz = class$15;
                if (clazz == null) {
                    try {
                        clazz = class$15 = Class.forName("java.sql.Timestamp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 92: {
                Class<?> clazz = class$13;
                if (clazz == null) {
                    try {
                        clazz = class$13 = Class.forName("java.sql.Time");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 93: {
                Class<?> clazz = class$15;
                if (clazz == null) {
                    try {
                        clazz = class$15 = Class.forName("java.sql.Timestamp");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case -4: 
            case -3: 
            case -2: {
                return ValueTypes.getValueType(BYTE_ARRAY_CLASS);
            }
            case -1: 
            case 1: 
            case 12: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
            case 16: {
                Class<?> clazz = class$18;
                if (clazz == null) {
                    try {
                        clazz = class$18 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ValueTypes.getValueType(clazz);
            }
        }
        return OBJECT;
    }
}

