/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.struts.factory;

import java.lang.reflect.Field;
import java.util.Map;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.struts.config.StrutsActionConfig;
import org.seasar.struts.config.StrutsActionFormConfig;
import org.seasar.struts.config.StrutsActionForwardConfig;
import org.seasar.struts.config.StrutsActionPropertyConfig;
import org.seasar.struts.config.StrutsActionPropertyConfigImpl;
import org.seasar.struts.factory.AnnotationHandler;
import org.seasar.struts.util.ConstantValueUtil;

public class ConstantAnnotationHandler
implements AnnotationHandler {
    private static final String ACTION = "ACTION";
    private static final String FORM = "FORM";
    private static final String FORWARD_SUFFIX = "_FORWARD";
    private static final String EXPORT_SUFFIX = "_EXPORT";

    public StrutsActionConfig createStrutsActionConfig(Class clazz) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
        if (!beanDesc.hasField(ACTION)) {
            return null;
        }
        String value = (String)beanDesc.getFieldValue(ACTION, null);
        final Map parameters = ConstantValueUtil.toMap(value);
        return new StrutsActionConfig(){

            public String path() {
                String value = (String)parameters.get("path");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String name() {
                String value = (String)parameters.get("name");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String scope() {
                String value = (String)parameters.get("scope");
                if (value == null) {
                    return "request";
                }
                return value;
            }

            public boolean validate() {
                String value = (String)parameters.get("validate");
                if (value == null) {
                    return true;
                }
                return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
            }

            public String input() {
                String value = (String)parameters.get("input");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String parameter() {
                String value = (String)parameters.get("parameter");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String attribute() {
                String value = (String)parameters.get("attribute");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String forward() {
                String value = (String)parameters.get("forward");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String include() {
                String value = (String)parameters.get("include");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String prefix() {
                String value = (String)parameters.get("prefix");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public String suffix() {
                String value = (String)parameters.get("suffix");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public boolean unknown() {
                String value = (String)parameters.get("unknown");
                if (value == null) {
                    return false;
                }
                return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
            }

            public String roles() {
                String value = (String)parameters.get("roles");
                if (value == null) {
                    return "";
                }
                return value;
            }
        };
    }

    public StrutsActionForwardConfig createStrutsActionForwardConfig(Field field) {
        String fieldName = field.getName() + FORWARD_SUFFIX;
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(field.getDeclaringClass());
        if (!beanDesc.hasField(fieldName)) {
            return null;
        }
        String value = (String)beanDesc.getFieldValue(fieldName, null);
        final Map parameters = ConstantValueUtil.toMap(value, "path");
        return new StrutsActionForwardConfig(){

            public String path() {
                return (String)parameters.get("path");
            }

            public boolean redirect() {
                String value = (String)parameters.get("redirect");
                if (value == null) {
                    return false;
                }
                return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
            }
        };
    }

    public StrutsActionFormConfig createStrutsActionFormConfig(Class clazz) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
        if (!beanDesc.hasField(FORM)) {
            return null;
        }
        String value = (String)beanDesc.getFieldValue(FORM, null);
        final Map parameters = ConstantValueUtil.toMap(value, "name");
        return new StrutsActionFormConfig(){

            public String name() {
                String value = (String)parameters.get("name");
                if (value == null) {
                    return "";
                }
                return value;
            }

            public boolean restricted() {
                String value = (String)parameters.get("restricted");
                if (value == null) {
                    return false;
                }
                return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
            }
        };
    }

    public StrutsActionPropertyConfig createStrutsActionPropertyConfig(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        String fieldName = propertyDesc.getPropertyName() + EXPORT_SUFFIX;
        if (!beanDesc.hasField(fieldName)) {
            return new StrutsActionPropertyConfigImpl();
        }
        String value = (String)beanDesc.getFieldValue(fieldName, null);
        return new StrutsActionPropertyConfigImpl(value);
    }
}

