/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.lang.reflect.Field;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.factory.AbstractAnnotationHandler;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;

public class ConstantAnnotationHandler
extends AbstractAnnotationHandler {
    public ComponentDef createComponentDef(Class componentClass) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        if (!beanDesc.hasField("COMPONENT")) {
            return new ComponentDefImpl(componentClass);
        }
        Field field = beanDesc.getField("COMPONENT");
        String componentStr = (String)FieldUtil.get(field, null);
        String[] array = StringUtil.split(componentStr, "=, ");
        ComponentDefImpl componentDef = new ComponentDefImpl(componentClass);
        int i = 0;
        while (i < array.length) {
            String key = array[i].trim();
            String value = array[i + 1].trim();
            if ("name".equalsIgnoreCase(key)) {
                componentDef.setComponentName(value);
            } else if ("instance".equalsIgnoreCase(key)) {
                componentDef.setInstanceDef(InstanceDefFactory.getInstanceDef(value));
            } else if ("autoBinding".equalsIgnoreCase(key)) {
                componentDef.setAutoBindingDef(AutoBindingDefFactory.getAutoBindingDef(value));
            } else {
                throw new IllegalArgumentException(componentStr);
            }
            i += 2;
        }
        return componentDef;
    }

    public PropertyDef createPropertyDef(BeanDesc beanDesc, PropertyDesc propertyDesc) {
        String propName = propertyDesc.getPropertyName();
        String fieldName = String.valueOf(propName) + "_BINDING";
        if (!beanDesc.hasField(fieldName)) {
            return null;
        }
        String bindingStr = (String)beanDesc.getFieldValue(fieldName, null);
        String bindingTypeName = null;
        String expression = null;
        if (bindingStr != null) {
            String[] array = StringUtil.split(bindingStr, "=, ");
            int i = 0;
            while (i < array.length) {
                String key = array[i].trim();
                String value = array[i + 1].trim();
                if ("bindingType".equalsIgnoreCase(key)) {
                    bindingTypeName = value;
                } else if ("value".equalsIgnoreCase(key)) {
                    expression = value;
                } else {
                    throw new IllegalArgumentException(bindingStr);
                }
                i += 2;
            }
        }
        return this.createPropertyDef(propName, bindingTypeName, expression);
    }

    public void appendAspect(ComponentDef componentDef) {
        Class componentClass = componentDef.getComponentClass();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(componentClass);
        if (!beanDesc.hasField("ASPECT")) {
            return;
        }
        String aspectStr = (String)beanDesc.getFieldValue("ASPECT", null);
        String[] array = StringUtil.split(aspectStr, "=, ");
        String interceptor = null;
        String pointcut = null;
        int i = 0;
        while (i < array.length) {
            String key = array[i].trim();
            String value = array[i + 1].trim();
            if ("interceptor".equalsIgnoreCase(key)) {
                interceptor = value;
            } else if ("pointcut".equalsIgnoreCase(key)) {
                pointcut = value;
            } else {
                throw new IllegalArgumentException(aspectStr);
            }
            i += 2;
        }
        this.appendAspect(componentDef, interceptor, pointcut);
    }

    protected void appendAspect(ComponentDef componentDef, String interceptor, String pointcut) {
        if (interceptor == null) {
            throw new EmptyRuntimeException("interceptor");
        }
        AspectDef aspectDef = AspectDefFactory.createAspectDef(interceptor, pointcut);
        componentDef.addAspectDef(aspectDef);
    }
}

