/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoNotFoundRuntimeException;
import org.seasar.dao.Dbms;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.AbstractAutoStaticCommand;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DeleteAutoStaticCommand;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.dao.impl.FieldAnnotationReader;
import org.seasar.dao.impl.InsertAutoStaticCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TextUtil;

public class DaoMetaDataImpl
implements DaoMetaData {
    private static final Pattern startWithOrderByPattern = Pattern.compile("(/\\*[^*]+\\*/)*order by", 2);
    private static final String[] INSERT_NAMES = new String[]{"insert", "create", "add"};
    private static final String[] UPDATE_NAMES = new String[]{"update", "modify", "store"};
    private static final String[] DELETE_NAMES = new String[]{"delete", "remove"};
    private static final String NOT_SINGLE_ROW_UPDATED = "NotSingleRowUpdated";
    protected Class daoClass_;
    protected Class daoInterface_;
    protected BeanDesc daoBeanDesc_;
    protected DataSource dataSource_;
    protected DaoAnnotationReader annotationReader_;
    protected StatementFactory statementFactory_;
    protected ResultSetFactory resultSetFactory_;
    protected Dbms dbms_;
    protected Class beanClass_;
    protected BeanMetaData beanMetaData_;
    protected Map sqlCommands_ = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DaoMetaDataImpl(Class daoClass, DataSource dataSource, StatementFactory statementFactory, ResultSetFactory resultSetFactory) {
        this.daoClass_ = daoClass;
        this.daoBeanDesc_ = BeanDescFactory.getBeanDesc((Class)daoClass);
        this.daoInterface_ = DaoMetaDataImpl.getDaoInterface(daoClass);
        this.annotationReader_ = new FieldAnnotationReader(this.daoBeanDesc_);
        this.beanClass_ = this.annotationReader_.getBeanClass();
        this.dataSource_ = dataSource;
        this.statementFactory_ = statementFactory;
        this.resultSetFactory_ = resultSetFactory;
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource_);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData((Connection)con);
            this.dbms_ = DbmsManager.getDbms(dbMetaData);
            this.beanMetaData_ = new BeanMetaDataImpl(this.beanClass_, dbMetaData, this.dbms_);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            ConnectionUtil.close((Connection)con);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        ConnectionUtil.close((Connection)con);
        this.setupSqlCommand();
    }

    protected void setupSqlCommand() {
        BeanDesc idbd = BeanDescFactory.getBeanDesc((Class)this.daoInterface_);
        String[] names = idbd.getMethodNames();
        int i = 0;
        while (i < names.length) {
            Method[] methods = this.daoBeanDesc_.getMethods(names[i]);
            if (methods.length == 1 && MethodUtil.isAbstract((Method)methods[0])) {
                this.setupMethod(methods[0]);
            }
            ++i;
        }
    }

    protected void setupMethod(Method method) {
        String sql = null;
        sql = this.annotationReader_.getSQL(method.getName(), this.dbms_.getSuffix());
        if (sql != null) {
            this.setupMethodByManual(method, sql);
            return;
        }
        String base = String.valueOf(this.daoInterface_.getName().replace('.', '/')) + "_" + method.getName();
        String dbmsPath = String.valueOf(base) + this.dbms_.getSuffix() + ".sql";
        String standardPath = String.valueOf(base) + ".sql";
        if (ResourceUtil.isExist((String)dbmsPath)) {
            sql = TextUtil.readText((String)dbmsPath);
            this.setupMethodByManual(method, sql);
        } else if (ResourceUtil.isExist((String)standardPath)) {
            sql = TextUtil.readText((String)standardPath);
            this.setupMethodByManual(method, sql);
        } else {
            this.setupMethodByAuto(method);
        }
    }

    protected void setupMethodByManual(Method method, String sql) {
        if (this.isSelect(method)) {
            this.setupSelectMethodByManual(method, sql);
        } else {
            this.setupUpdateMethodByManual(method, sql);
        }
    }

    protected void setupMethodByAuto(Method method) {
        if (this.isInsert(method.getName())) {
            this.setupInsertMethodByAuto(method);
        } else if (this.isUpdate(method.getName())) {
            this.setupUpdateMethodByAuto(method);
        } else if (this.isDelete(method.getName())) {
            this.setupDeleteMethodByAuto(method);
        } else {
            this.setupSelectMethodByAuto(method);
        }
    }

    protected void setupSelectMethodByManual(Method method, String sql) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(this.createResultSetHandler(method));
        cmd.setSql(sql);
        cmd.setArgNames(this.annotationReader_.getArgNames(method.getName()));
        cmd.setArgTypes(method.getParameterTypes());
        this.sqlCommands_.put(method.getName(), cmd);
    }

    protected SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler rsh) {
        return new SelectDynamicCommand(this.dataSource_, this.statementFactory_, rsh, this.resultSetFactory_);
    }

    protected SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler resultSetHandler, String query) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(resultSetHandler);
        StringBuffer buf = new StringBuffer(255);
        if (DaoMetaDataImpl.startsWithSelect(query)) {
            buf.append(query);
        } else {
            String sql = this.dbms_.getAutoSelectSql(this.getBeanMetaData());
            buf.append(sql);
            if (query != null) {
                if (DaoMetaDataImpl.startsWithOrderBy(query)) {
                    buf.append(" ");
                } else if (sql.lastIndexOf("WHERE") < 0) {
                    buf.append(" WHERE ");
                } else {
                    buf.append(" AND ");
                }
                buf.append(query);
            }
        }
        cmd.setSql(buf.toString());
        return cmd;
    }

    protected static boolean startsWithSelect(String query) {
        return StringUtil.startsWith((String)query, (String)"select");
    }

    protected static boolean startsWithOrderBy(String query) {
        Matcher m;
        return query != null && (m = startWithOrderByPattern.matcher(query)).lookingAt();
    }

    protected ResultSetHandler createResultSetHandler(Method method) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(method.getReturnType())) {
            return new BeanListMetaDataResultSetHandler(this.beanMetaData_);
        }
        if (this.isBeanClassAssignable(method.getReturnType())) {
            return new BeanMetaDataResultSetHandler(this.beanMetaData_);
        }
        if (Array.newInstance(this.beanClass_, 0).getClass().isAssignableFrom(method.getReturnType())) {
            return new BeanArrayMetaDataResultSetHandler(this.beanMetaData_);
        }
        return new ObjectResultSetHandler();
    }

    protected boolean isBeanClassAssignable(Class clazz) {
        return this.beanClass_.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.beanClass_);
    }

    protected void setupUpdateMethodByManual(Method method, String sql) {
        UpdateDynamicCommand cmd = new UpdateDynamicCommand(this.dataSource_, this.statementFactory_);
        cmd.setSql(sql);
        String[] argNames = this.annotationReader_.getArgNames(method.getName());
        if (argNames.length == 0 && this.isUpdateSignatureForBean(method)) {
            argNames = new String[]{StringUtil.decapitalize((String)ClassUtil.getShortClassName((Class)this.beanClass_))};
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(method.getParameterTypes());
        cmd.setNotSingleRowUpdatedExceptionClass(this.getNotSingleRowUpdatedExceptionClass(method));
        this.sqlCommands_.put(method.getName(), cmd);
    }

    protected boolean isUpdateSignatureForBean(Method method) {
        return method.getParameterTypes().length == 1 && this.isBeanClassAssignable(method.getParameterTypes()[0]);
    }

    protected Class getNotSingleRowUpdatedExceptionClass(Method method) {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes != null) {
            int i = 0;
            while (i < exceptionTypes.length) {
                Class<?> exceptionType = exceptionTypes[i];
                if (exceptionType.getName().indexOf(NOT_SINGLE_ROW_UPDATED) >= 0) {
                    return exceptionType;
                }
                ++i;
            }
        }
        return null;
    }

    protected void setupInsertMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method.getName());
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new InsertAutoStaticCommand(this.dataSource_, this.statementFactory_, this.beanMetaData_, propertyNames) : new InsertBatchAutoStaticCommand(this.dataSource_, this.statementFactory_, this.beanMetaData_, propertyNames);
        this.sqlCommands_.put(method.getName(), cmd);
    }

    protected void setupUpdateMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method.getName());
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new UpdateAutoStaticCommand(this.dataSource_, this.statementFactory_, this.beanMetaData_, propertyNames) : new UpdateBatchAutoStaticCommand(this.dataSource_, this.statementFactory_, this.beanMetaData_, propertyNames);
        this.sqlCommands_.put(method.getName(), cmd);
    }

    protected void setupDeleteMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method.getName());
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new DeleteAutoStaticCommand(this.dataSource_, this.statementFactory_, this.beanMetaData_, propertyNames) : new DeleteBatchAutoStaticCommand(this.dataSource_, this.statementFactory_, this.beanMetaData_, propertyNames);
        this.sqlCommands_.put(method.getName(), cmd);
    }

    protected String[] getPersistentPropertyNames(String methodName) {
        PropertyType pt;
        int i;
        ArrayList<String> names = new ArrayList<String>();
        String[] props = this.annotationReader_.getNoPersistentProps(methodName);
        if (props != null) {
            i = 0;
            while (i < this.beanMetaData_.getPropertyTypeSize()) {
                pt = this.beanMetaData_.getPropertyType(i);
                if (pt.isPersistent() && !this.isPropertyExist(props, pt.getPropertyName())) {
                    names.add(pt.getPropertyName());
                }
                ++i;
            }
        } else {
            props = this.annotationReader_.getPersistentProps(methodName);
            if (props != null) {
                names.addAll(Arrays.asList(props));
                i = 0;
                while (i < this.beanMetaData_.getPrimaryKeySize()) {
                    String pk = this.beanMetaData_.getPrimaryKey(i);
                    PropertyType pt2 = this.beanMetaData_.getPropertyTypeByColumnName(pk);
                    names.add(pt2.getPropertyName());
                    ++i;
                }
                if (this.beanMetaData_.hasVersionNoPropertyType()) {
                    names.add(this.beanMetaData_.getVersionNoPropertyName());
                }
                if (this.beanMetaData_.hasTimestampPropertyType()) {
                    names.add(this.beanMetaData_.getTimestampPropertyName());
                }
            }
        }
        if (names.size() == 0) {
            i = 0;
            while (i < this.beanMetaData_.getPropertyTypeSize()) {
                pt = this.beanMetaData_.getPropertyType(i);
                if (pt.isPersistent()) {
                    names.add(pt.getPropertyName());
                }
                ++i;
            }
        }
        return names.toArray(new String[names.size()]);
    }

    protected boolean isPropertyExist(String[] props, String propertyName) {
        int i = 0;
        while (i < props.length) {
            if (props[i].equalsIgnoreCase(propertyName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setupSelectMethodByAuto(Method method) {
        String query = this.annotationReader_.getQuery(method.getName());
        ResultSetHandler handler = this.createResultSetHandler(method);
        SelectDynamicCommand cmd = null;
        String[] argNames = this.annotationReader_.getArgNames(method.getName());
        if (query != null && !DaoMetaDataImpl.startsWithOrderBy(query)) {
            cmd = this.createSelectDynamicCommand(handler, query);
        } else {
            cmd = this.createSelectDynamicCommand(handler);
            String sql = null;
            if (argNames.length == 0 && method.getParameterTypes().length == 1) {
                argNames = new String[]{"dto"};
                sql = this.createAutoSelectSqlByDto(method.getParameterTypes()[0]);
            } else {
                sql = this.createAutoSelectSql(argNames);
            }
            if (query != null) {
                sql = String.valueOf(sql) + " " + query;
            }
            cmd.setSql(sql);
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(method.getParameterTypes());
        this.sqlCommands_.put(method.getName(), cmd);
    }

    protected String createAutoSelectSqlByDto(Class dtoClass) {
        String sql = this.dbms_.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        DtoMetaDataImpl dmd = new DtoMetaDataImpl(dtoClass);
        boolean began = false;
        if (sql.lastIndexOf("WHERE") <= 0) {
            buf.append("/*BEGIN*/ WHERE ");
            began = true;
        }
        int i = 0;
        while (i < dmd.getPropertyTypeSize()) {
            PropertyType pt = dmd.getPropertyType(i);
            String aliasName = pt.getColumnName();
            if (this.beanMetaData_.hasPropertyTypeByAliasName(aliasName) && this.beanMetaData_.getPropertyTypeByAliasName(aliasName).isPersistent()) {
                String columnName = this.beanMetaData_.convertFullColumnName(aliasName);
                String propertyName = "dto." + pt.getPropertyName();
                buf.append("/*IF ");
                buf.append(propertyName);
                buf.append(" != null*/");
                buf.append(" ");
                if (!began || i != 0) {
                    buf.append("AND ");
                }
                buf.append(columnName);
                buf.append(" = /*");
                buf.append(propertyName);
                buf.append("*/null");
                buf.append("/*END*/");
            }
            ++i;
        }
        if (began) {
            buf.append("/*END*/");
        }
        return buf.toString();
    }

    protected String createAutoSelectSql(String[] argNames) {
        String sql = this.dbms_.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        if (argNames.length != 0) {
            boolean began = false;
            if (sql.lastIndexOf("WHERE") <= 0) {
                buf.append("/*BEGIN*/ WHERE ");
                began = true;
            }
            int i = 0;
            while (i < argNames.length) {
                String columnName = this.beanMetaData_.convertFullColumnName(argNames[i]);
                buf.append("/*IF ");
                buf.append(argNames[i]);
                buf.append(" != null*/");
                buf.append(" ");
                if (!began || i != 0) {
                    buf.append("AND ");
                }
                buf.append(columnName);
                buf.append(" = /*");
                buf.append(argNames[i]);
                buf.append("*/null");
                buf.append("/*END*/");
                ++i;
            }
            if (began) {
                buf.append("/*END*/");
            }
        }
        return buf.toString();
    }

    protected void checkAutoUpdateMethod(Method method) {
        block8: {
            block7: {
                if (method.getParameterTypes().length != 1) break block7;
                if (this.isBeanClassAssignable(method.getParameterTypes()[0])) break block8;
                Class<?> clazz = method.getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.util.List");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(clazz2) || method.getParameterTypes()[0].isArray()) break block8;
            }
            throw new IllegalSignatureRuntimeException("EDAO0006", method.toString());
        }
    }

    protected boolean isSelect(Method method) {
        if (this.isInsert(method.getName())) {
            return false;
        }
        if (this.isUpdate(method.getName())) {
            return false;
        }
        return !this.isDelete(method.getName());
    }

    protected boolean isInsert(String methodName) {
        int i = 0;
        while (i < INSERT_NAMES.length) {
            if (methodName.startsWith(INSERT_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isUpdate(String methodName) {
        int i = 0;
        while (i < UPDATE_NAMES.length) {
            if (methodName.startsWith(UPDATE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isDelete(String methodName) {
        int i = 0;
        while (i < DELETE_NAMES.length) {
            if (methodName.startsWith(DELETE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Class getBeanClass() {
        return this.daoClass_;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData_;
    }

    public SqlCommand getSqlCommand(String methodName) throws MethodNotFoundRuntimeException {
        SqlCommand cmd = (SqlCommand)this.sqlCommands_.get(methodName);
        if (cmd == null) {
            throw new MethodNotFoundRuntimeException(this.daoClass_, methodName, null);
        }
        return cmd;
    }

    public boolean hasSqlCommand(String methodName) {
        return this.sqlCommands_.containsKey(methodName);
    }

    public SqlCommand createFindCommand(String query) {
        return this.createSelectDynamicCommand(new BeanListMetaDataResultSetHandler(this.beanMetaData_), query);
    }

    public SqlCommand createFindArrayCommand(String query) {
        return this.createSelectDynamicCommand(new BeanArrayMetaDataResultSetHandler(this.beanMetaData_), query);
    }

    public SqlCommand createFindBeanCommand(String query) {
        return this.createSelectDynamicCommand(new BeanMetaDataResultSetHandler(this.beanMetaData_), query);
    }

    public SqlCommand createFindObjectCommand(String query) {
        return this.createSelectDynamicCommand((ResultSetHandler)new ObjectResultSetHandler(), query);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class getDaoInterface(Class clazz) {
        Class<?> clazz2;
        if (clazz.isInterface()) {
            return clazz;
        }
        Class target = clazz;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Class<?>[] interfaces = target.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    Class<?> intf = interfaces[i];
                    if (intf.getName().endsWith("Dao")) {
                        return intf;
                    }
                    ++i;
                }
                target = target.getSuperclass();
            }
            if ((clazz2 = class$1) != null) continue;
            try {
                clazz2 = Class.forName("org.seasar.dao.impl.AbstractDao");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (target != clazz2);
        throw new DaoNotFoundRuntimeException(clazz);
    }

    public void setDbms(Dbms dbms) {
        this.dbms_ = dbms;
    }
}

