/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.hql.ClauseParser;
import net.sf.hibernate.hql.Parser;
import net.sf.hibernate.hql.ParserHelper;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.util.StringHelper;

public class PreprocessingParser
implements Parser {
    private static final Set HQL_OPERATORS = new HashSet();
    private static final Map HQL_COLLECTION_PROPERTIES;
    private Map replacements;
    private boolean quoted;
    private StringBuffer quotedString;
    private ClauseParser parser = new ClauseParser();
    private String lastToken;
    private String currentCollectionProp;

    public PreprocessingParser(Map replacements) {
        this.replacements = replacements;
    }

    public void token(String token, QueryTranslator q) throws QueryException {
        if (this.quoted) {
            this.quotedString.append(token);
        }
        if ("'".equals(token)) {
            if (this.quoted) {
                token = this.quotedString.toString();
            } else {
                this.quotedString = new StringBuffer(20).append(token);
            }
            boolean bl = this.quoted = !this.quoted;
        }
        if (this.quoted) {
            return;
        }
        if (ParserHelper.isWhitespace(token)) {
            return;
        }
        String substoken = (String)this.replacements.get(token);
        String string = token = substoken == null ? token : substoken;
        if (this.currentCollectionProp != null) {
            if ("(".equals(token)) {
                return;
            }
            if (")".equals(token)) {
                this.currentCollectionProp = null;
                return;
            }
            token = StringHelper.qualify(token, this.currentCollectionProp);
        } else {
            String prop = (String)HQL_COLLECTION_PROPERTIES.get(token.toLowerCase());
            if (prop != null) {
                this.currentCollectionProp = prop;
                return;
            }
        }
        if (this.lastToken == null) {
            this.lastToken = token;
        } else {
            String doubleToken;
            String string2 = doubleToken = token.length() > 1 ? this.lastToken + ' ' + token : this.lastToken + token;
            if (HQL_OPERATORS.contains(doubleToken.toLowerCase())) {
                this.parser.token(doubleToken, q);
                this.lastToken = null;
            } else {
                this.parser.token(this.lastToken, q);
                this.lastToken = token;
            }
        }
    }

    public void start(QueryTranslator q) throws QueryException {
        this.quoted = false;
        this.parser.start(q);
    }

    public void end(QueryTranslator q) throws QueryException {
        if (this.lastToken != null) {
            this.parser.token(this.lastToken, q);
        }
        this.parser.end(q);
        this.lastToken = null;
        this.currentCollectionProp = null;
    }

    static {
        HQL_OPERATORS.add("<=");
        HQL_OPERATORS.add(">=");
        HQL_OPERATORS.add("=>");
        HQL_OPERATORS.add("=<");
        HQL_OPERATORS.add("!=");
        HQL_OPERATORS.add("<>");
        HQL_OPERATORS.add("!#");
        HQL_OPERATORS.add("!~");
        HQL_OPERATORS.add("!<");
        HQL_OPERATORS.add("!>");
        HQL_OPERATORS.add("is not");
        HQL_OPERATORS.add("not like");
        HQL_OPERATORS.add("not in");
        HQL_OPERATORS.add("not between");
        HQL_OPERATORS.add("not exists");
        HQL_COLLECTION_PROPERTIES = new HashMap();
        HQL_COLLECTION_PROPERTIES.put("elements", "elements");
        HQL_COLLECTION_PROPERTIES.put("indices", "indices");
        HQL_COLLECTION_PROPERTIES.put("size", "size");
        HQL_COLLECTION_PROPERTIES.put("maxindex", "maxIndex");
        HQL_COLLECTION_PROPERTIES.put("minindex", "minIndex");
        HQL_COLLECTION_PROPERTIES.put("maxelement", "maxElement");
        HQL_COLLECTION_PROPERTIES.put("minelement", "minElement");
        HQL_COLLECTION_PROPERTIES.put("index", "index");
    }
}

