/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hibernate.impl;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cfg.Configuration;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TransactionManagerUtil;
import org.seasar.framework.util.TransactionUtil;
import org.seasar.hibernate.HibernateRuntimeException;
import org.seasar.hibernate.S2Session;
import org.seasar.hibernate.S2SessionFactory;
import org.seasar.hibernate.impl.S2SessionImpl;

public final class S2SessionFactoryImpl
implements S2SessionFactory {
    private static final String DEFAULT_CONFIG_PATH = "hibernate.cfg.xml";
    private final TransactionManager transactionManager_;
    private final DataSource dataSource_;
    private String configPath_ = "hibernate.cfg.xml";
    private Interceptor interceptor_;
    private SessionFactory sessionFactory_;
    private final Map txSessions_ = Collections.synchronizedMap(new HashMap());

    public S2SessionFactoryImpl(TransactionManager transactionManager, DataSource dataSource) {
        this.transactionManager_ = transactionManager;
        this.dataSource_ = dataSource;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public DataSource getDataSource() {
        return this.dataSource_;
    }

    public String getConfigPath() {
        return this.configPath_;
    }

    public void setConfigPath(String configPath) {
        this.configPath_ = configPath;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor_ = interceptor;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory_ != null) {
            return this.sessionFactory_;
        }
        Configuration cfg = new Configuration();
        try {
            cfg.configure(ResourceUtil.getResource((String)this.configPath_));
            if (this.interceptor_ != null) {
                cfg.setInterceptor(this.interceptor_);
            }
            this.sessionFactory_ = cfg.buildSessionFactory();
        }
        catch (HibernateException ex) {
            throw new HibernateRuntimeException(ex);
        }
        return this.sessionFactory_;
    }

    public int getTxSessionSize() {
        return this.txSessions_.size();
    }

    public S2Session getSession() {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            return this.createSession();
        }
        S2Session session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        return this.bindSession(tx);
    }

    private Transaction getTransaction() {
        return TransactionManagerUtil.getTransaction((TransactionManager)this.getTransactionManager());
    }

    private S2Session createSession() {
        SessionFactory factory = this.getSessionFactory();
        return new S2SessionImpl(factory.openSession(this.getConnection()));
    }

    private Connection getConnection() {
        return DataSourceUtil.getConnection((DataSource)this.getDataSource());
    }

    private S2Session bindSession(Transaction tx) {
        S2Session session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen()) {
            return session;
        }
        session = this.createSession();
        this.txSessions_.put(tx, session);
        TransactionUtil.registerSynchronization((Transaction)tx, (Synchronization)new SynchronizationImpl(tx));
        return session;
    }

    private void closeSession(Transaction tx) {
        S2Session session = (S2Session)this.txSessions_.remove(tx);
        if (session != null && session.isOpen()) {
            try {
                session.clear();
            }
            finally {
                Connection connection = session.close();
                ConnectionUtil.close((Connection)connection);
            }
        }
    }

    private void flushSession(Transaction tx) {
        S2Session session = null;
        session = (S2Session)this.txSessions_.get(tx);
        if (session != null && session.isOpen() && !session.isReadOnly()) {
            session.flush();
        }
    }

    private class SynchronizationImpl
    implements Synchronization {
        private Transaction tx_;

        public SynchronizationImpl(Transaction tx) {
            this.tx_ = tx;
        }

        public void beforeCompletion() {
            S2SessionFactoryImpl.this.flushSession(this.tx_);
        }

        public void afterCompletion(int arg0) {
            S2SessionFactoryImpl.this.closeSession(this.tx_);
        }
    }
}

