package examples.hibernate.dao;

import java.math.BigDecimal;
import java.util.List;

import examples.hibernate.dto.EmployeeSalDto;
import examples.hibernate.dto.EmployeeSearchDto;
import examples.hibernate.dto.EmployeeSimpleDto;
import examples.hibernate.entity.Employee;

public interface EmployeeAutoDao {
	public Class BEAN = Employee.class;

	//ǉA폜AXVAۑorXVꍇ
	public void save(Employee employee);
	public void delete(Employee employee);
	public void update(Employee employee);
	public void saveOrUpdate(Employee employee);

	//IuWFNg̎擾
	public Employee load(Integer empno);

	//IuWFNgbNĎ擾
	public String loadLock_LOCK = "UPGRADE" ;
	public Employee loadLock(Integer empno);
	
	//HQLw肵ȂŎsꍇ
	public String getEmployeeByEmpNo_ARGS = "empno";
	public Employee getEmployeeByEmpNo(Integer empNo);

	public String getEmployeeByJobDeptno_ARGS = "job,deptno";
	public List getEmployeeByJobDeptno(String job, int deptno);
	
	//HQLw肵Ďsꍇ
	public String getHQLAllEmployee_HQL = "from Employee emp order by emp.empno";
	public List getHQLAllEmployee();

	//w肵ĂȂꍇ
	public List getAllEmployee();

	//firstResult,maxResultsw肷ꍇ
	public String getEmployeeList_ARGS = "firstResult,maxResults";
	public String getEmployeeList_HQL = "from Employee emp order by emp.empno";
	public List getEmployeeList(int firstResult ,int MaxResults );

	//߂lint̏ꍇ
	public String getEmployeeCount_HQL = "select count(emp) from Employee emp";
	public int getEmployeeCount();

	//߂lString̏ꍇ
	public String getEmployeeNameById_HQL 
				= "select emp.ename from Employee emp where empno = :employeeId ";
	public String getEmployeeNameById_ARGS = "employeeId";
	public String getEmployeeNameById(Integer employeeId);

	//NamedQueryĂяogꍇ
	//(Employee.hbm.xml"examples.hibernate.dao.EmployeeAutoDao_getEmployeeByJob"ɑΉ)
	public String getEmployeeByJob_ARGS = "job";
	public List getEmployeeByJob(String job);

	//NamedQueryŖ߂lStringɂȂ悤SQLgꍇ
	//(Employee.hbm.xml"examples.hibernate.dao.EmployeeAutoDao_getSQLEmployeeNameById"ɑΉ)
	public String getSQLEmployeeNameById_ARGS = "employeeId";
	public String getSQLEmployeeNameById(Integer employeeId);	
	
	//NamedQueryŖ߂lLongɂȂ悤SQLgꍇ
	//(Employee.hbm.xml"getSQLEmployeeIdByName"NamedQuerys)
	public String getSQLEmployeeIdByName_ARGS = "employeeName";
	public Integer getSQLEmployeeIdByName(String employeeName);
	
	//ListĂꍇ
	public String getEmployeeByIdList_HQL = "from Employee emp where emp.empno in (:empnoList)";
	public String getEmployeeByIdList_ARGS = "empnoList";
	public List   getEmployeeByIdList( List empnoList );
	
	//OrderBỹtB[hw肷ꍇ
	public String getEmployeeOrderByField_ARGS = "orderBy";
	public List   getEmployeeOrderByField( String orderBy );
	
	//ARGSAme[VɔrIy[^[i>jw肵ꍇ
	public String getEmployeeByGtSal_ARGS = "sal >";
	public List   getEmployeeByGtSal( BigDecimal sal );

	//ARGSAme[VɔrIy[^[i<jw肵ꍇ
	public String getEmployeeByLtSal_ARGS = "sal <";
	public List   getEmployeeByLtSal( BigDecimal sal );
	
	//ARGSAme[VɔrIy[^[i>,<jw肵ꍇ
	//w肵tB[hw肵͈͂̒l̃IuWFNg擾Ƃ
	public String getEmployeeByGtLtSal_ARGS = "sal >,sal <";
	public List   getEmployeeByGtLtSal( BigDecimal BigDecimal ,BigDecimal toSal );


	//ARGSAme[VɔrIy[^[i=jw肵ꍇ
	public String getEmployeeByJobDeptnoEq_ARGS = "job =,deptno =";
	public List getEmployeeByJobDeptnoEq(String job, int deptno);
	
	//ARGSAme[VɔrIy[^[ilikejw肵ꍇ
	public String getEmployeeByLikeEmane_ARGS = "ename like";
	public List   getEmployeeByLikeEmane( String ename );

	//ARGSAme[VɔrIy[^[iinjw肵ꍇ
	public String getEmployeeByInIdList_ARGS = "empno in";
	public List   getEmployeeByInIdList( List empnoList );
		
	//ARGSAme[VɔrIy[^[i>=,<=jw肵ꍇiEmployeeSearchDtoj
	//w肵tB[hw肵͈͂̒l̃IuWFNg擾Ƃ
	public String getEmployeeByDto_PROPERTY = "empno,ename,job,mgr,deptno," +
			"hiredate >= fromHiredate,hiredate <= toHiredate,sal >= fromSal,sal <= toSal";
	public List   getEmployeeByDto( EmployeeSearchDto dto );

	//dtoƂEmployeew肵ďꍇ
	public List   getEmployeeByEmployeeDtoAuto( Employee dto );
	
	//dtoƂEmployeeSimpleDtow肵ďꍇ
	public List   getEmployeeByEmployeeSimpleDtoAuto( EmployeeSimpleDto dto );

	//Dto̒lHQLɓnĎsꍇ
	
	public String getEmployeeBySalDto_PROPERTY = "fromSal,toSal";
	public List   getEmployeeBySalDto( EmployeeSalDto dto );
	
}
